/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private final JTree tree;

    public TreeTableCellEditor(JTree tree) {
        super(new TreeTableTextField());
        if (tree == null) {
            throw new IllegalArgumentException("null tree");
        }
        this.tree = tree;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.initEditorOffset(table, row, column, isSelected);
        return component;
    }

    protected void initEditorOffset(JTable table, int row, int column, boolean isSelected) {
        JLabel label;
        Icon icon;
        if (this.tree == null) {
            return;
        }
        Rectangle bounds = this.tree.getRowBounds(row);
        int offset = bounds.x;
        Object node = this.tree.getPathForRow(row).getLastPathComponent();
        boolean leaf = this.tree.getModel().isLeaf(node);
        boolean expanded = this.tree.isExpanded(row);
        TreeCellRenderer tcr = this.tree.getCellRenderer();
        Component treeComponent = tcr.getTreeCellRendererComponent(this.tree, node, isSelected, expanded, leaf, row, false);
        if (treeComponent instanceof JLabel && table.getComponentOrientation().isLeftToRight() && (icon = (label = (JLabel)treeComponent).getIcon()) != null) {
            offset += icon.getIconWidth() + label.getIconTextGap();
        }
        ((TreeTableTextField)this.getComponent()).init(offset, column, bounds.width, table);
    }

    public boolean isCellEditable(EventObject e) {
        if (e == null) {
            return true;
        }
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= this.clickCountToStart;
        }
        return false;
    }

    static class TreeTableTextField
    extends JTextField {
        private int offset;
        private int column;
        private int width;
        private JTable table;

        TreeTableTextField() {
        }

        void init(int offset, int column, int width, JTable table) {
            this.offset = offset;
            this.column = column;
            this.width = width;
            this.table = table;
            this.setComponentOrientation(table.getComponentOrientation());
        }

        public void reshape(int x, int y, int width, int height) {
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int newOffset = this.offset - this.getInsets().left;
                super.reshape(x + newOffset, y, width - newOffset, height);
            } else {
                int newOffset = this.offset + this.getInsets().left;
                int pos = this.getColumnPositionBidi();
                width = this.table.getColumnModel().getColumn(this.getBidiTreeColumn()).getWidth();
                width -= width - newOffset - this.width;
                super.reshape(pos, y, width, height);
            }
        }

        private int getBidiTreeColumn() {
            return this.table.getColumnCount() - this.column - 1;
        }

        private int getColumnPositionBidi() {
            int width = 0;
            int column = this.getBidiTreeColumn();
            for (int iter = 0; iter < column; ++iter) {
                width += this.table.getColumnModel().getColumn(iter).getWidth();
            }
            return width;
        }
    }
}

