/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.sample.ofc;

import com.jaspersoft.sample.ofc.BarChartComponent;
import com.jaspersoft.sample.ofc.FillBarDataset;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import ofc4j.model.Chart;
import ofc4j.model.axis.XAxis;
import ofc4j.model.axis.YAxis;
import ofc4j.model.elements.BarChart;
import ofc4j.model.elements.Element;

public class FillBarChart
extends BaseFillComponent
implements JRFillCloneable {
    public static final JRGenericElementType CHART_PRINT_TYPE = new JRGenericElementType("http://jaspersoft.com/sample/openflashchart", "chart");
    private static final String BGCOLOR = "ffffff";
    private static final String[] COLORS = new String[]{"fadf12", "ed262a", "006f3c", "fa6112", "409dcf", "e5018c", "eaab35"};
    private final BarChartComponent chart;
    private final FillBarDataset dataset;
    private String title;

    public FillBarChart(BarChartComponent chart, JRFillObjectFactory factory) {
        this.chart = chart;
        this.dataset = new FillBarDataset(chart.getDataset(), factory);
        factory.registerElementDataset((JRFillElementDataset)this.dataset);
    }

    protected boolean isEvaluateNow() {
        return this.chart.getEvaluationTime() == 1;
    }

    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateChart(evaluation);
        }
    }

    protected void evaluateChart(byte evaluation) throws JRException {
        this.title = (String)this.fillContext.evaluate(this.chart.getTitleExpression(), evaluation);
        this.dataset.evaluateDatasetRun(evaluation);
    }

    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), CHART_PRINT_TYPE);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template);
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy((JRGenericPrintElement)printElement);
        } else {
            this.fillContext.registerDelayedEvaluation((JRPrintElement)printElement, this.chart.getEvaluationTime(), this.chart.getEvaluationGroup());
        }
        return printElement;
    }

    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        throw new UnsupportedOperationException();
    }

    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateChart(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        this.dataset.finishDataset();
        Chart ofchart = new Chart(this.title);
        ofchart.setBackgroundColour(BGCOLOR);
        XAxis xAxis = new XAxis();
        for (String category : this.dataset.getCategories()) {
            xAxis.addLabels(new String[]{category});
        }
        ofchart.setXAxis(xAxis);
        int seriesIdx = 0;
        double max = 0.0;
        for (String seriesKey : this.dataset.getSeriesKeys()) {
            BarChart barChart = new BarChart(BarChart.Style.GLASS);
            barChart.setAlpha(Float.valueOf(0.9f));
            barChart.setColour(COLORS[seriesIdx % COLORS.length]);
            for (String category : this.dataset.getCategories()) {
                Number value = this.dataset.getValue(seriesKey, category);
                if (value == null) {
                    value = 0.0;
                }
                barChart.addValues(new Number[]{value});
                if (!(value.doubleValue() > max)) continue;
                max = value.doubleValue();
            }
            ofchart.addElements(new Element[]{barChart});
            ++seriesIdx;
        }
        int yMax = (int)Math.ceil(max);
        int m = 1;
        while (yMax > 100) {
            yMax = (int)Math.ceil((double)yMax / 10.0);
            m *= 10;
        }
        yMax = 5 * (int)Math.ceil((double)yMax / 5.0);
        YAxis yAxis = new YAxis();
        yAxis.setMax(Integer.valueOf(yMax *= m));
        yAxis.setSteps(Integer.valueOf(yMax / 5));
        ofchart.setYAxis(yAxis);
        String chartData = ofchart.toString();
        printElement.setParameterValue("ChartData", (Object)chartData);
    }
}

