/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.binding.method.InvalidMethodSignatureException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.ObjectUtils;

public class ClassMethodKey
implements Serializable {
    private Class type;
    private String methodName;
    private Class[] parameterTypes;
    private transient Method method;

    public ClassMethodKey(Class type, String methodName, Class[] parameterTypes) {
        this.type = type;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public Class getType() {
        return this.type;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Method getMethod() throws InvalidMethodSignatureException {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected Method resolveMethod() throws InvalidMethodSignatureException {
        try {
            return this.type.getMethod(this.getMethodName(), this.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            Method method = this.findMethodConsiderAssignableParameterTypes();
            if (method != null) {
                return method;
            }
            throw new InvalidMethodSignatureException(this, e);
        }
    }

    protected Method findMethodConsiderAssignableParameterTypes() {
        Method[] candidateMethods = this.getType().getMethods();
        for (int i = 0; i < candidateMethods.length; ++i) {
            Class<?>[] candidateParameterTypes;
            if (!candidateMethods[i].getName().equals(this.getMethodName()) || (candidateParameterTypes = candidateMethods[i].getParameterTypes()).length != this.getParameterTypes().length) continue;
            int numberOfCorrectArguments = 0;
            for (int j = 0; j < candidateParameterTypes.length; ++j) {
                Class<?> candidateType = candidateParameterTypes[j];
                Class parameterType = this.parameterTypes[j];
                if (parameterType != null) {
                    if (!BeanUtils.isAssignable(candidateType, (Class)parameterType)) continue;
                    ++numberOfCorrectArguments;
                    continue;
                }
                ++numberOfCorrectArguments;
            }
            if (numberOfCorrectArguments != this.parameterTypes.length) continue;
            return candidateMethods[i];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassMethodKey)) {
            return false;
        }
        ClassMethodKey other = (ClassMethodKey)obj;
        return this.type.equals(other.type) && this.methodName.equals(other.methodName) && this.argumentTypesEqual(other.parameterTypes);
    }

    private boolean argumentTypesEqual(Class[] other) {
        if (this.parameterTypes == other) {
            return true;
        }
        if (this.parameterTypes.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (ObjectUtils.nullSafeEquals((Object)this.parameterTypes[i], (Object)other[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.type.hashCode() + this.methodName.hashCode() + this.argumentTypesHash();
    }

    private int argumentTypesHash() {
        if (this.parameterTypes == null) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            Class parameterType = this.parameterTypes[i];
            if (parameterType == null) continue;
            hash += this.parameterTypes[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("type", (Object)this.type).append("methodName", (Object)this.methodName).append("parameterTypes", (Object)this.parameterTypes).toString();
    }
}

