/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class MemberBase
extends OlapElementBase
implements Member {
    protected Member parentMember;
    protected final Level level;
    protected String uniqueName;
    protected final int flags;
    private static final int FLAG_TYPE_MASK = 7;
    private static final int FLAG_HIDDEN = 8;
    private static final int FLAG_ALL = 16;
    private static final int FLAG_NULL = 32;
    private static final int FLAG_CALCULATED = 64;
    private static final int FLAG_MEASURE = 128;
    protected String parentUniqueName;
    private static final Member.MemberType[] MEMBER_TYPE_VALUES = Member.MemberType.values();

    protected MemberBase(Member parentMember, Level level, Member.MemberType memberType) {
        this.parentMember = parentMember;
        this.level = level;
        this.parentUniqueName = parentMember == null ? null : parentMember.getUniqueName();
        this.flags = memberType.ordinal() | (memberType == Member.MemberType.ALL ? 16 : 0) | (memberType == Member.MemberType.NULL ? 32 : 0) | (this.computeCalculated(memberType) ? 64 : 0) | (level.getHierarchy().getDimension().isMeasures() ? 128 : 0);
    }

    protected MemberBase() {
        this.level = null;
        this.flags = 0;
        this.parentUniqueName = null;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxMemberName.str(this.getUniqueName());
    }

    public abstract String getName();

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getCaption() {
        MemberFormatter mf = this.getLevel().getMemberFormatter();
        if (mf != null) {
            return mf.formatMember(this);
        }
        String caption = super.getCaption();
        return caption != null ? caption : this.getName();
    }

    public String getParentUniqueName() {
        return this.parentUniqueName;
    }

    public Dimension getDimension() {
        return this.getLevel().getDimension();
    }

    public Hierarchy getHierarchy() {
        return this.getLevel().getHierarchy();
    }

    public Level getLevel() {
        return this.level;
    }

    public Member.MemberType getMemberType() {
        return MEMBER_TYPE_VALUES[this.flags & 7];
    }

    public String getDescription() {
        return null;
    }

    public boolean isMeasure() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isAll() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isNull() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isCalculated() {
        return (this.flags & 0x40) != 0;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment childName) {
        return this.lookupChild(schemaReader, childName, MatchType.EXACT);
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment childName, MatchType matchType) {
        return schemaReader.lookupMemberChildByName(this, childName, matchType);
    }

    public Member getParentMember() {
        if (this.parentUniqueName == null) {
            return null;
        }
        if (this.parentMember != null) {
            return this.parentMember;
        }
        boolean failIfNotFound = true;
        Hierarchy hierarchy = this.getHierarchy();
        SchemaReader schemaReader = hierarchy.getDimension().getSchema().getSchemaReader();
        List<Id.Segment> parentUniqueNameParts = Util.parseIdentifier(this.parentUniqueName);
        this.parentMember = schemaReader.getMemberByUniqueName(parentUniqueNameParts, failIfNotFound);
        return this.parentMember;
    }

    public boolean isChildOrEqualTo(Member member) {
        return member != null && this.isChildOrEqualTo(member.getUniqueName());
    }

    public boolean isChildOrEqualTo(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        String thisUniqueName = this.getUniqueName();
        if (thisUniqueName.equals(uniqueName)) {
            return true;
        }
        String parentUniqueName = this.getParentUniqueName();
        return parentUniqueName == null ? false : ((MemberBase)this.getParentMember()).isChildOrEqualTo(uniqueName);
    }

    protected boolean computeCalculated(Member.MemberType memberType) {
        return this.isCalculatedInQuery() || memberType == Member.MemberType.FORMULA;
    }

    public int getSolveOrder() {
        return -1;
    }

    public Exp getExpression() {
        return null;
    }

    public Member[] getAncestorMembers() {
        ArrayList<Member> list = new ArrayList<Member>();
        for (Member parentMember = this.getParentMember(); parentMember != null; parentMember = parentMember.getParentMember()) {
            list.add(parentMember);
        }
        return list.toArray(new Member[list.size()]);
    }

    public int getOrdinal() {
        return -1;
    }

    public Comparable getOrderKey() {
        return null;
    }

    public boolean isHidden() {
        return false;
    }

    public Member getDataMember() {
        return null;
    }

    public String getPropertyFormattedValue(String propertyName) {
        return this.getPropertyValue(propertyName).toString();
    }
}

