/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractTupleCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class TupleFunDef
extends FunDefBase {
    private final int[] argTypes;
    static final ResolverImpl Resolver = new ResolverImpl();

    private TupleFunDef(int[] argTypes) {
        super("()", "(<Member> [, <Member>]...)", "Parenthesis operator constructs a tuple.  If there is only one member, the expression is equivalent to the member expression.", Syntax.Parentheses, 10, argTypes);
        this.argTypes = argTypes;
    }

    public int getReturnCategory() {
        return 10;
    }

    public int[] getParameterCategories() {
        return this.argTypes;
    }

    public void unparse(Exp[] args, PrintWriter pw) {
        ExpBase.unparseList(pw, args, "(", ", ", ")");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 1) {
            return TypeUtil.toMemberType(args[0].getType());
        }
        Type[] types = new MemberType[args.length];
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            types[i] = TypeUtil.toMemberType(arg.getType());
        }
        this.checkDimensions((MemberType[])types);
        return new TupleType(types);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        MemberCalc[] memberCalcs = new MemberCalc[args.length];
        for (int i = 0; i < args.length; ++i) {
            memberCalcs[i] = compiler.compileMember(args[i]);
        }
        return new CalcImpl(call, memberCalcs);
    }

    private void checkDimensions(MemberType[] memberTypes) {
        for (int i = 0; i < memberTypes.length; ++i) {
            MemberType memberType = memberTypes[i];
            for (int j = 0; j < i; ++j) {
                MemberType member1 = memberTypes[j];
                Dimension dimension = memberType.getDimension();
                Dimension dimension1 = member1.getDimension();
                if (dimension == null || dimension != dimension1) continue;
                throw MondrianResource.instance().DupDimensionsInTuple.ex(dimension.getUniqueName());
            }
        }
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("()", null, null, Syntax.Parentheses);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length == 1) {
                return new ParenthesesFunDef(args[0].getCategory());
            }
            int[] argTypes = new int[args.length];
            for (int i = 0; i < args.length; ++i) {
                Exp arg = args[i];
                if (!validator.canConvert(arg, 6, conversionCount)) {
                    return null;
                }
                argTypes[i] = 6;
            }
            return new TupleFunDef(argTypes);
        }
    }

    public static class CalcImpl
    extends AbstractTupleCalc {
        private final MemberCalc[] memberCalcs;

        public CalcImpl(ResolvedFunCall call, MemberCalc[] memberCalcs) {
            super(call, memberCalcs);
            this.memberCalcs = memberCalcs;
        }

        public Member[] evaluateTuple(Evaluator evaluator) {
            Member[] members = new Member[this.memberCalcs.length];
            for (int i = 0; i < members.length; ++i) {
                members[i] = this.memberCalcs[i].evaluateMember(evaluator);
                Member member = members[i];
                if (member != null && !member.isNull()) continue;
                return null;
            }
            return members;
        }

        public MemberCalc[] getMemberCalcs() {
            return this.memberCalcs;
        }
    }
}

