/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Category;
import mondrian.olap.Hierarchy;
import mondrian.olap.Util;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.CubeType;
import mondrian.olap.type.DateTimeType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NullType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    public static Hierarchy typeToHierarchy(Type type) {
        if (type instanceof MemberType || type instanceof LevelType || type instanceof HierarchyType || type instanceof DimensionType) {
            return type.getHierarchy();
        }
        throw Util.newInternal("not an mdx object");
    }

    public static Type stripSetType(Type type) {
        while (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        return type;
    }

    public static Type toMemberOrTupleType(Type type) {
        if ((type = TypeUtil.stripSetType(type)) instanceof TupleType) {
            return type;
        }
        return TypeUtil.toMemberType(type);
    }

    public static MemberType toMemberType(Type type) {
        if ((type = TypeUtil.stripSetType(type)) instanceof MemberType) {
            return (MemberType)type;
        }
        if (type instanceof DimensionType || type instanceof HierarchyType || type instanceof LevelType) {
            return MemberType.forType(type);
        }
        return null;
    }

    public static boolean isUnionCompatible(Type type1, Type type2) {
        if (type1 instanceof TupleType) {
            TupleType tupleType1 = (TupleType)type1;
            if (type2 instanceof TupleType) {
                TupleType tupleType2 = (TupleType)type2;
                if (tupleType1.elementTypes.length == tupleType2.elementTypes.length) {
                    for (int i = 0; i < tupleType1.elementTypes.length; ++i) {
                        if (TypeUtil.isUnionCompatible(tupleType1.elementTypes[i], tupleType2.elementTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        MemberType memberType1 = TypeUtil.toMemberType(type1);
        if (memberType1 == null) {
            return false;
        }
        MemberType memberType2 = TypeUtil.toMemberType(type2);
        if (memberType2 == null) {
            return false;
        }
        Hierarchy hierarchy1 = memberType1.getHierarchy();
        Hierarchy hierarchy2 = memberType2.getHierarchy();
        return TypeUtil.equal(hierarchy1, hierarchy2);
    }

    private static boolean equal(Hierarchy hierarchy1, Hierarchy hierarchy2) {
        return hierarchy1 == null || hierarchy2 == null || hierarchy2.getUniqueName().equals(hierarchy1.getUniqueName());
    }

    public static boolean canEvaluate(Type type) {
        return !(type instanceof SetType) && !(type instanceof CubeType) && !(type instanceof LevelType);
    }

    public static boolean isSet(Type type) {
        return type instanceof SetType;
    }

    public static boolean couldBeMember(Type type) {
        return type instanceof MemberType || type instanceof HierarchyType || type instanceof DimensionType;
    }

    public static int typeToCategory(Type type) {
        if (type instanceof NullType) {
            return 16;
        }
        if (type instanceof DateTimeType) {
            return 18;
        }
        if (type instanceof NumericType) {
            return 7;
        }
        if (type instanceof BooleanType) {
            return 5;
        }
        if (type instanceof DimensionType) {
            return 2;
        }
        if (type instanceof HierarchyType) {
            return 3;
        }
        if (type instanceof MemberType) {
            return 6;
        }
        if (type instanceof LevelType) {
            return 4;
        }
        if (type instanceof SymbolType) {
            return 11;
        }
        if (type instanceof StringType) {
            return 9;
        }
        if (type instanceof ScalarType) {
            return 13;
        }
        if (type instanceof SetType) {
            return 8;
        }
        if (type instanceof TupleType) {
            return 10;
        }
        throw Util.newInternal("Unknown type " + type);
    }

    public static Type computeCommonType(boolean allowConversions, Type ... types) {
        int[] nArray;
        if (types.length == 0) {
            return null;
        }
        Type type = types[0];
        if (allowConversions) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = null;
        }
        int[] conversionCount = nArray;
        for (int i = 1; i < types.length; ++i) {
            if (type == null) {
                return null;
            }
            type = type.computeCommonType(types[i], conversionCount);
        }
        return type;
    }

    public static boolean canConvert(int from, int to, int[] conversionCount) {
        if (from == to) {
            return true;
        }
        switch (from) {
            case 1: {
                return false;
            }
            case 2: {
                switch (to) {
                    case 6: 
                    case 10: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                    case 3: 
                    case 4: {
                        conversionCount[0] = conversionCount[0] + 2;
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (to) {
                    case 2: 
                    case 6: 
                    case 10: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (to) {
                    case 2: {
                        conversionCount[0] = conversionCount[0] + 2;
                        return true;
                    }
                    case 3: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                switch (to) {
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 6: {
                switch (to) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 10: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                    case 7: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                    case 9: 
                    case 13: {
                        conversionCount[0] = conversionCount[0] + 2;
                        return true;
                    }
                }
                return false;
            }
            case 71: {
                return to == 13 || to == 7;
            }
            case 7: {
                switch (to) {
                    case 5: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                }
                return to == 13 || to == 15 || to == 79 || to == 71;
            }
            case 15: {
                return to == 13 || to == 79 || to == 7 || to == 71;
            }
            case 8: {
                return false;
            }
            case 73: {
                return to == 13 || to == 9;
            }
            case 9: {
                return to == 13 || to == 73;
            }
            case 82: {
                return to == 13 || to == 18;
            }
            case 18: {
                return to == 13 || to == 82;
            }
            case 10: {
                switch (to) {
                    case 7: 
                    case 13: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                }
                return false;
            }
            case 13: {
                return false;
            }
            case 11: {
                return false;
            }
            case 16: {
                if (Category.isScalar(to)) {
                    return true;
                }
                if (to == 6) {
                    conversionCount[0] = conversionCount[0] + 2;
                    return true;
                }
                return false;
            }
            case 17: {
                return false;
            }
        }
        throw Util.newInternal("unknown category " + from);
    }

    static <T> T neq(T t1, T t2) {
        return (T)(t1 == null ? t2 : (t2 == null ? t1 : (t1.equals(t2) ? t1 : null)));
    }
}

