/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.LevelType;
import mondrian.olap.MemberFormatter;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.MemberTuplePredicate;
import mondrian.rolap.agg.RangeColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

public class RolapCubeLevel
extends RolapLevel {
    private final RolapLevel rolapLevel;
    private RolapStar.Column starKeyColumn = null;
    protected LevelReader levelReader;

    public RolapCubeLevel(RolapLevel level, RolapCubeHierarchy hierarchy) {
        super(hierarchy, level.getDepth(), level.getName(), level.getKeyExp(), level.getNameExp(), level.getCaptionExp(), level.getOrdinalExp(), level.getParentExp(), level.getNullParentValue(), null, level.getProperties(), level.getFlags(), level.getDatatype(), level.getHideMemberCondition(), level.getLevelType(), "" + level.getApproxRowCount());
        this.rolapLevel = level;
        MondrianDef.RelationOrJoin hierarchyRel = hierarchy.getRelation();
        this.keyExp = this.convertExpression(level.getKeyExp(), hierarchyRel);
        this.nameExp = this.convertExpression(level.getNameExp(), hierarchyRel);
        this.captionExp = this.convertExpression(level.getCaptionExp(), hierarchyRel);
        this.ordinalExp = this.convertExpression(level.getOrdinalExp(), hierarchyRel);
        this.parentExp = this.convertExpression(level.getParentExp(), hierarchyRel);
    }

    void init(MondrianDef.CubeDimension xmlDimension) {
        if (this.isAll()) {
            this.levelReader = new AllLevelReaderImpl();
        } else if (this.getLevelType() == LevelType.Null) {
            this.levelReader = new NullLevelReader();
        } else if (this.rolapLevel.xmlClosure != null) {
            RolapDimension dimension = (RolapDimension)this.rolapLevel.getClosedPeer().getHierarchy().getDimension();
            RolapCubeDimension cubeDimension = new RolapCubeDimension(this.getCube(), dimension, xmlDimension, this.getDimension().getName() + "$Closure", this.getHierarchy().getDimension().getOrdinal());
            this.getCube().createUsage((RolapCubeHierarchy)cubeDimension.getHierarchies()[0], xmlDimension);
            cubeDimension.init(xmlDimension);
            this.getCube().registerDimension(cubeDimension);
            RolapCubeLevel closedPeer = (RolapCubeLevel)cubeDimension.getHierarchies()[0].getLevels()[1];
            this.levelReader = new ParentChildLevelReaderImpl(closedPeer);
        } else {
            this.levelReader = new RegularLevelReader();
        }
    }

    private MondrianDef.Expression convertExpression(MondrianDef.Expression exp, MondrianDef.RelationOrJoin rel) {
        if (this.getHierarchy().isUsingCubeFact()) {
            return exp;
        }
        if (exp == null || rel == null) {
            return null;
        }
        if (exp instanceof MondrianDef.Column) {
            MondrianDef.Column col = (MondrianDef.Column)exp;
            if (rel instanceof MondrianDef.Table) {
                return new MondrianDef.Column(((MondrianDef.Table)rel).getAlias(), col.getColumnName());
            }
            if (rel instanceof MondrianDef.Join || rel instanceof MondrianDef.Relation) {
                String alias = this.getHierarchy().lookupAlias(col.getTableAlias());
                return new MondrianDef.Column(alias, col.getColumnName());
            }
        } else if (exp instanceof MondrianDef.ExpressionView) {
            return exp;
        }
        throw new RuntimeException("conversion of Class " + ((Object)((Object)exp)).getClass() + " unsupported at this time");
    }

    public void setStarKeyColumn(RolapStar.Column column) {
        this.starKeyColumn = column;
    }

    public RolapStar.Column getStarKeyColumn() {
        return this.starKeyColumn;
    }

    LevelReader getLevelReader() {
        return this.levelReader;
    }

    public RolapStar.Column getBaseStarKeyColumn(RolapCube baseCube) {
        RolapStar.Column column = null;
        if (this.getCube().isVirtual()) {
            RolapCubeLevel lvl = baseCube.findBaseCubeLevel(this);
            if (lvl != null) {
                column = lvl.getStarKeyColumn();
            }
        } else {
            column = this.getStarKeyColumn();
        }
        return column;
    }

    public RolapCube getCube() {
        return this.getHierarchy().getDimension().getCube();
    }

    public final RolapCubeHierarchy getHierarchy() {
        return (RolapCubeHierarchy)super.getHierarchy();
    }

    public final RolapCubeLevel getChildLevel() {
        return (RolapCubeLevel)super.getChildLevel();
    }

    public RolapCubeLevel getParentLevel() {
        return (RolapCubeLevel)super.getParentLevel();
    }

    public RolapLevel getRolapLevel() {
        return this.rolapLevel;
    }

    public boolean equals(RolapCubeLevel level) {
        return super.equals(level) && this.getCube().equals(level.getCube());
    }

    boolean hasClosedPeer() {
        return this.rolapLevel.hasClosedPeer();
    }

    public MemberFormatter getMemberFormatter() {
        return this.rolapLevel.getMemberFormatter();
    }

    static class NullLevelReader
    implements LevelReader {
        NullLevelReader() {
        }

        public boolean constrainRequest(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
            return true;
        }

        public void constrainRegion(StarColumnPredicate predicate, RolapCube baseCube, RolapCacheRegion cacheRegion) {
        }
    }

    static class AllLevelReaderImpl
    implements LevelReader {
        AllLevelReaderImpl() {
        }

        public boolean constrainRequest(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
            return false;
        }

        public void constrainRegion(StarColumnPredicate predicate, RolapCube baseCube, RolapCacheRegion cacheRegion) {
        }
    }

    class ParentChildLevelReaderImpl
    extends RegularLevelReader {
        protected final RolapCubeLevel closedPeer;

        ParentChildLevelReaderImpl(RolapCubeLevel closedPeer) {
            this.closedPeer = closedPeer;
        }

        public boolean constrainRequest(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
            if (member.getDataMember() == null) {
                return super.constrainRequest(member, baseCube, request);
            }
            if (request.drillThrough) {
                member = (RolapCubeMember)member.getDataMember();
                return super.constrainRequest(member, baseCube, request);
            }
            RolapCubeLevel level = this.closedPeer;
            RolapMember wrappedAllMember = (RolapMember)RolapCubeLevel.this.rolapLevel.getClosedPeer().getHierarchy().getDefaultMember();
            RolapCubeMember allMember = (RolapCubeMember)level.getHierarchy().getDefaultMember();
            assert (allMember.isAll());
            RolapMember wrappedMember = new RolapMember(wrappedAllMember, RolapCubeLevel.this.rolapLevel.getClosedPeer(), member.getKey());
            member = new RolapCubeMember(allMember, wrappedMember, this.closedPeer, RolapCubeLevel.this.getCube());
            return level.getLevelReader().constrainRequest(member, baseCube, request);
        }

        public void constrainRegion(StarColumnPredicate predicate, RolapCube baseCube, RolapCacheRegion cacheRegion) {
            throw new UnsupportedOperationException();
        }
    }

    class RegularLevelReader
    implements LevelReader {
        RegularLevelReader() {
        }

        public boolean constrainRequest(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
            LevelReader levelReader;
            assert (member.getLevel() == RolapCubeLevel.this);
            if (member.getKey() == null) {
                if (member == member.getHierarchy().getNullMember()) {
                    return true;
                }
                throw Util.newInternal("why is key null?");
            }
            RolapStar.Column column = RolapCubeLevel.this.getBaseStarKeyColumn(baseCube);
            if (column == null) {
                return member != RolapCubeLevel.this.hierarchy.getDefaultMember() || RolapCubeLevel.this.hierarchy.hasAll();
            }
            ValueColumnPredicate predicate = member.isCalculated() ? null : new ValueColumnPredicate(column, member.getKey());
            request.addConstrainedColumn(column, predicate);
            if (request.extendedContext && RolapCubeLevel.this.getNameExp() != null) {
                RolapStar.Column nameColumn = column.getNameColumn();
                assert (nameColumn != null);
                request.addConstrainedColumn(nameColumn, null);
            }
            if (member.isCalculated()) {
                return false;
            }
            if (RolapCubeLevel.this.isUnique()) {
                return false;
            }
            RolapCubeMember parent = member.getParentMember();
            while (true) {
                if (parent == null) {
                    return false;
                }
                RolapCubeLevel level = parent.getLevel();
                levelReader = level.levelReader;
                if (levelReader != this) break;
                parent = parent.getParentMember();
            }
            return levelReader.constrainRequest(parent, baseCube, request);
        }

        public void constrainRegion(StarColumnPredicate predicate, RolapCube baseCube, RolapCacheRegion cacheRegion) {
            RolapStar.Column column = RolapCubeLevel.this.getBaseStarKeyColumn(baseCube);
            if (column == null) {
                return;
            }
            if (predicate instanceof MemberColumnPredicate) {
                MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)predicate;
                RolapMember member = memberColumnPredicate.getMember();
                assert (member.getLevel() == RolapCubeLevel.this);
                assert (!member.isCalculated());
                assert (memberColumnPredicate.getMember().getKey() != null);
                assert (!member.isNull());
                cacheRegion.addPredicate(column, predicate);
                return;
            }
            if (predicate instanceof RangeColumnPredicate) {
                RolapMember upperMember;
                RolapMember lowerMember;
                RangeColumnPredicate rangeColumnPredicate = (RangeColumnPredicate)predicate;
                ValueColumnPredicate lowerBound = rangeColumnPredicate.getLowerBound();
                if (lowerBound == null) {
                    lowerMember = null;
                } else if (lowerBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)lowerBound;
                    lowerMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                ValueColumnPredicate upperBound = rangeColumnPredicate.getUpperBound();
                if (upperBound == null) {
                    upperMember = null;
                } else if (upperBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)upperBound;
                    upperMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                MemberTuplePredicate predicate2 = new MemberTuplePredicate(baseCube, lowerMember, !rangeColumnPredicate.getLowerInclusive(), upperMember, !rangeColumnPredicate.getUpperInclusive());
                cacheRegion.addPredicate(predicate2);
                return;
            }
            throw new UnsupportedOperationException();
        }
    }

    static interface LevelReader {
        public boolean constrainRequest(RolapCubeMember var1, RolapCube var2, CellRequest var3);

        public void constrainRegion(StarColumnPredicate var1, RolapCube var2, RolapCacheRegion var3);
    }
}

