/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.NonEmptyCrossJoinFunDef;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapUtil;

public class RolapNativeCrossJoin
extends RolapNativeSet {
    public RolapNativeCrossJoin() {
        super.setEnabled(MondrianProperties.instance().EnableNativeCrossJoin.get());
    }

    protected boolean restrictMemberTypes() {
        return false;
    }

    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        RolapCube cube = evaluator.getCube();
        RolapNativeSet.CrossJoinArg[] cargs = this.checkCrossJoin(evaluator, fun, args);
        if (cargs == null) {
            this.alertCrossJoinNonNative(evaluator, fun, "arguments not supported");
            return null;
        }
        int countNonNativeInputArg = 0;
        for (RolapNativeSet.CrossJoinArg arg : cargs) {
            if (!(arg instanceof RolapNativeSet.MemberListCrossJoinArg)) continue;
            RolapNativeSet.MemberListCrossJoinArg cjArg = (RolapNativeSet.MemberListCrossJoinArg)arg;
            if (cjArg.hasAllMember()) {
                ++countNonNativeInputArg;
            }
            if (!cjArg.hasCalcMembers()) continue;
            countNonNativeInputArg = cargs.length;
            break;
        }
        if (countNonNativeInputArg == cargs.length) {
            this.alertCrossJoinNonNative(evaluator, fun, "either all arguments contain the ALL member or one has a calculated member");
            return null;
        }
        if (this.isPreferInterpreter(cargs, true)) {
            return null;
        }
        Level[] levels = new RolapLevel[cargs.length];
        for (int i = 0; i < cargs.length; ++i) {
            levels[i] = cargs[i].getLevel();
        }
        if (cube.isVirtual() && !evaluator.getQuery().nativeCrossJoinVirtualCube()) {
            this.alertCrossJoinNonNative(evaluator, fun, "not all functions on [Measures] dimension supported");
            return null;
        }
        if (!NonEmptyCrossJoinConstraint.isValidContext(evaluator, false, levels)) {
            return null;
        }
        if (!evaluator.isNonEmpty()) {
            return null;
        }
        LOGGER.debug((Object)"using native crossjoin");
        evaluator = evaluator.push();
        Member[] evalMembers = (Member[])evaluator.getMembers().clone();
        for (Level level : levels) {
            RolapHierarchy hierarchy = ((RolapLevel)level).getHierarchy();
            for (int i = 0; i < evalMembers.length; ++i) {
                Dimension evalMemberDimension = evalMembers[i].getHierarchy().getDimension();
                if (evalMemberDimension != hierarchy.getDimension()) continue;
                evalMembers[i] = hierarchy.getAllMember();
            }
        }
        evaluator.setContext(evalMembers);
        NonEmptyCrossJoinConstraint constraint = new NonEmptyCrossJoinConstraint(cargs, evaluator);
        SchemaReader schemaReader = evaluator.getSchemaReader();
        return new RolapNativeSet.SetEvaluator(this, cargs, schemaReader, constraint);
    }

    private void alertCrossJoinNonNative(RolapEvaluator evaluator, FunDef fun, String reason) {
        if (!(fun instanceof NonEmptyCrossJoinFunDef)) {
            return;
        }
        if (!evaluator.getQuery().shouldAlertForNonNative(fun)) {
            return;
        }
        RolapUtil.alertNonNative("NonEmptyCrossJoin", reason);
    }

    static class NonEmptyCrossJoinConstraint
    extends RolapNativeSet.SetConstraint {
        NonEmptyCrossJoinConstraint(RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator) {
            super(args, evaluator, false);
        }
    }
}

