/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Pattern;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;

class MdxUtil {
    private static final Pattern QUOT_PATTERN = Pattern.compile("\"", 16);

    MdxUtil() {
    }

    static String quoteForMdx(String val) {
        StringBuilder buf = new StringBuilder(val.length() + 20);
        buf.append("\"");
        buf.append(QUOT_PATTERN.matcher(val).replaceAll("\"\""));
        buf.append("\"");
        return buf.toString();
    }

    static String toString(ParseTreeNode node) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter(pw);
        node.unparse(parseTreeWriter);
        pw.flush();
        return sw.toString();
    }

    static String mdxEncodeString(String st) {
        StringBuilder retString = new StringBuilder(st.length() + 20);
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            if (c == ']' && i + 1 < st.length() && st.charAt(i + 1) != '.') {
                retString.append(']');
            }
            retString.append(c);
        }
        return retString.toString();
    }
}

