/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.sample.ofc;

import com.jaspersoft.sample.ofc.FillPieDataset;
import com.jaspersoft.sample.ofc.PieChartComponent;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import ofc4j.model.Chart;
import ofc4j.model.elements.Element;
import ofc4j.model.elements.PieChart;

public class FillPieChart
extends BaseFillComponent
implements JRFillCloneable {
    public static final JRGenericElementType CHART_PRINT_TYPE = new JRGenericElementType("http://jaspersoft.com/sample/openflashchart", "chart");
    private static final String BGCOLOR = "ffffff";
    private static final String[] COLORS = new String[]{"fadf12", "ed262a", "006f3c", "fa6112", "409dcf", "e5018c", "eaab35"};
    private final PieChartComponent chart;
    private final FillPieDataset dataset;
    private String title;

    public FillPieChart(PieChartComponent chart, JRFillObjectFactory factory) {
        this.chart = chart;
        this.dataset = new FillPieDataset(chart.getDataset(), factory);
        factory.registerElementDataset((JRFillElementDataset)this.dataset);
    }

    protected boolean isEvaluateNow() {
        return this.chart.getEvaluationTime() == 1;
    }

    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateChart(evaluation);
        }
    }

    protected void evaluateChart(byte evaluation) throws JRException {
        this.title = (String)this.fillContext.evaluate(this.chart.getTitleExpression(), evaluation);
        this.dataset.evaluateDatasetRun(evaluation);
    }

    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), CHART_PRINT_TYPE);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template);
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy((JRGenericPrintElement)printElement);
        } else {
            this.fillContext.registerDelayedEvaluation((JRPrintElement)printElement, this.chart.getEvaluationTime(), this.chart.getEvaluationGroup());
        }
        return printElement;
    }

    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        throw new UnsupportedOperationException();
    }

    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateChart(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        this.dataset.finishDataset();
        PieChart pieChart = new PieChart();
        Iterator<String> keys = this.dataset.getKeys().iterator();
        Iterator<Number> values = this.dataset.getValues().iterator();
        while (keys.hasNext() && values.hasNext()) {
            String key = keys.next();
            Number value = values.next();
            pieChart.addSlice(value, key);
        }
        pieChart.setAnimate(true);
        pieChart.setStartAngle(Integer.valueOf(35));
        pieChart.setBorder(Integer.valueOf(2));
        pieChart.setAlpha(Float.valueOf(0.6f));
        pieChart.setColours(COLORS);
        pieChart.setTooltip("#val# of #total#<br>#percent# of 100%");
        Chart chart = new Chart(this.title);
        chart.addElements(new Element[]{pieChart});
        chart.setBackgroundColour(BGCOLOR);
        String chartData = chart.toString();
        int stardIdx = chartData.indexOf("\"values\"");
        int endIdx = chartData.indexOf(93, stardIdx);
        chartData = chartData.substring(0, stardIdx) + chartData.substring(stardIdx, endIdx).replaceAll("\"text\"", "\"label\"") + chartData.substring(endIdx);
        printElement.setParameterValue("ChartData", (Object)chartData);
    }
}

