/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseMeterPlot;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.base.JRBaseFont;

public class JRDesignMeterPlot
extends JRBaseMeterPlot {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DATA_RANGE = "dataRange";
    public static final String PROPERTY_METER_ANGLE = "meterAngle";
    public static final String PROPERTY_METER_BACKGROUND_COLOR = "meterBackgroundColor";
    public static final String PROPERTY_NEEDLE_COLOR = "needleColor";
    public static final String PROPERTY_SHAPE = "shape";
    public static final String PROPERTY_TICK_COLOR = "tickColor";
    public static final String PROPERTY_TICK_INTERVAL = "tickInterval";
    public static final String PROPERTY_UNITS = "units";
    public static final String PROPERTY_VALUE_DISPLAY = "valueDisplay";
    public static final String PROPERTY_INTERVALS = "intervals";
    public static final String PROPERTY_TICK_LABEL_FONT = "tickLabelFont";

    public JRDesignMeterPlot(JRChartPlot meterPlot, JRChart chart) {
        super(meterPlot, chart);
    }

    public void setDataRange(JRDataRange dataRange) throws JRException {
        JRDataRange old = this.dataRange;
        this.dataRange = dataRange;
        this.getEventSupport().firePropertyChange(PROPERTY_DATA_RANGE, old, this.dataRange);
    }

    public void setValueDisplay(JRValueDisplay valueDisplay) {
        JRValueDisplay old = this.valueDisplay;
        this.valueDisplay = new JRBaseValueDisplay(valueDisplay, this.getChart());
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE_DISPLAY, old, this.valueDisplay);
    }

    public void setShape(byte shape) throws JRException {
        this.setShape(new Byte(shape));
    }

    public void setShape(Byte shape) throws JRException {
        if (shape != null && (shape < 0 || shape > 3)) {
            throw new JRException("Unknown shape for MeterPlot");
        }
        Byte old = this.shapeByte;
        this.shapeByte = shape;
        this.getEventSupport().firePropertyChange(PROPERTY_SHAPE, old, this.shapeByte);
    }

    public void addInterval(JRMeterInterval interval) {
        this.intervals.add(interval);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_INTERVALS, interval, this.intervals.size() - 1);
    }

    public void clearIntervals() {
        this.setIntervals(null);
    }

    public void setIntervals(Collection intervals) {
        ArrayList old = new ArrayList(this.intervals);
        this.intervals.clear();
        if (intervals != null) {
            this.intervals.addAll(intervals);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_INTERVALS, old, this.intervals);
    }

    public void setMeterAngle(int meterAngle) {
        this.setMeterAngle(new Integer(meterAngle));
    }

    public void setMeterAngle(Integer meterAngle) {
        Integer old = this.meterAngleInteger;
        this.meterAngleInteger = meterAngle;
        this.getEventSupport().firePropertyChange(PROPERTY_METER_ANGLE, old, this.meterAngleInteger);
    }

    public void setUnits(String units) {
        String old = this.units;
        this.units = units;
        this.getEventSupport().firePropertyChange(PROPERTY_UNITS, old, this.units);
    }

    public void setTickInterval(double tickInterval) {
        this.setTickInterval(new Double(tickInterval));
    }

    public void setTickInterval(Double tickInterval) {
        Double old = this.tickIntervalDouble;
        this.tickIntervalDouble = tickInterval;
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_INTERVAL, old, this.tickIntervalDouble);
    }

    public void setMeterBackgroundColor(Color meterBackgroundColor) {
        Color old = this.meterBackgroundColor;
        this.meterBackgroundColor = meterBackgroundColor;
        this.getEventSupport().firePropertyChange(PROPERTY_METER_BACKGROUND_COLOR, old, this.meterBackgroundColor);
    }

    public void setNeedleColor(Color needleColor) {
        Color old = this.needleColor;
        this.needleColor = needleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_NEEDLE_COLOR, old, this.needleColor);
    }

    public void setTickColor(Color tickColor) {
        Color old = this.tickColor;
        this.tickColor = tickColor;
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_COLOR, old, this.tickColor);
    }

    public void setTickLabelFont(JRFont tickLabelFont) {
        JRFont old = this.tickLabelFont;
        this.tickLabelFont = new JRBaseFont(this.getChart(), tickLabelFont);
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_LABEL_FONT, old, this.tickLabelFont);
    }
}

