/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultExtensionsRegistry
implements ExtensionsRegistry {
    private final Log log = LogFactory.getLog((Class)DefaultExtensionsRegistry.class);
    public static final String EXTENSION_RESOURCE_NAME = "jasperreports_extension.properties";
    public static final String PROPERTY_REGISTRY_FACTORY_PREFIX = "net.sf.jasperreports.extension.registry.factory.";
    public static final String PROPERTY_REGISTRY_PREFIX = "net.sf.jasperreports.extension.";
    private final ReferenceMap registryCache = new ReferenceMap(2, 0);

    public List getExtensions(Class extensionType) {
        List registries = this.getRegistries();
        ArrayList extensions = new ArrayList(registries.size());
        Iterator it = registries.iterator();
        while (it.hasNext()) {
            ExtensionsRegistry registry = (ExtensionsRegistry)it.next();
            List registryExtensions = registry.getExtensions(extensionType);
            if (registryExtensions == null || registryExtensions.isEmpty()) continue;
            extensions.addAll(registryExtensions);
        }
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getRegistries() {
        List registries;
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = this.registryCache;
        synchronized (referenceMap) {
            registries = (List)this.registryCache.get(cacheKey);
            if (registries == null) {
                registries = this.loadRegistries();
                this.registryCache.put(cacheKey, (Object)registries);
            }
        }
        return registries;
    }

    protected List loadRegistries() {
        ArrayList allRegistries = new ArrayList();
        List extensionProperties = this.loadExtensionProperties();
        Iterator it = extensionProperties.iterator();
        while (it.hasNext()) {
            JRPropertiesMap properties = (JRPropertiesMap)it.next();
            List registries = this.loadRegistries(properties);
            allRegistries.addAll(registries);
        }
        return allRegistries;
    }

    protected List loadExtensionProperties() {
        List resources = JRLoader.getResources(EXTENSION_RESOURCE_NAME);
        HashSet<URL> loadedResources = new HashSet<URL>();
        ArrayList<JRPropertiesMap> propertiesList = new ArrayList<JRPropertiesMap>(resources.size());
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            URL resource = (URL)it.next();
            if (!loadedResources.add(resource)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading JasperReports extension properties resource " + resource));
            }
            JRPropertiesMap props = JRPropertiesMap.loadProperties(resource);
            propertiesList.add(props);
        }
        return propertiesList;
    }

    protected List loadRegistries(JRPropertiesMap properties) {
        ArrayList<ExtensionsRegistry> registries = new ArrayList<ExtensionsRegistry>();
        List factoryProps = JRProperties.getProperties(properties, PROPERTY_REGISTRY_FACTORY_PREFIX);
        Iterator it = factoryProps.iterator();
        while (it.hasNext()) {
            JRProperties.PropertySuffix factoryProp = (JRProperties.PropertySuffix)it.next();
            String registryId = factoryProp.getSuffix();
            String factoryClass = factoryProp.getValue();
            try {
                ExtensionsRegistry registry = this.instantiateRegistry(properties, registryId, factoryClass);
                registries.add(registry);
            }
            catch (Exception e) {
                this.log.error((Object)("Error instantiating extensions registry for " + registryId), (Throwable)e);
            }
        }
        return registries;
    }

    protected ExtensionsRegistry instantiateRegistry(JRPropertiesMap props, String registryId, String factoryClass) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Instantiating extensions registry for " + registryId + " using factory class " + factoryClass));
        }
        ExtensionsRegistryFactory factory = (ExtensionsRegistryFactory)ClassUtils.instantiateClass(factoryClass, ExtensionsRegistryFactory.class);
        ExtensionsRegistry registry = factory.createRegistry(registryId, props);
        return registry;
    }
}

