/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.GenericDOMParser;
import org.eigenbase.xom.wrappers.W3CDOMWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesDOMParser
extends GenericDOMParser {
    private DOMParser parser = new DOMParser();

    public XercesDOMParser() throws XOMException {
        this(false);
    }

    public XercesDOMParser(boolean bl) throws XOMException {
        try {
            if (!bl) {
                this.parser.setFeature("http://xml.org/sax/features/validation", false);
                this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
        }
        catch (SAXException sAXException) {
            throw new XOMException(sAXException, "Error setting up validation");
        }
        this.parser.setErrorHandler((ErrorHandler)this);
        this.document = new DocumentImpl();
    }

    protected Document parseInputSource(InputSource inputSource) throws XOMException {
        this.prepareParse();
        try {
            this.parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            this.handleErrors();
            throw new XOMException(sAXException, "Document parse failed");
        }
        catch (IOException iOException) {
            this.handleErrors();
            throw new XOMException(iOException, "Document parse failed");
        }
        this.handleErrors();
        return this.parser.getDocument();
    }

    public DOMWrapper create(String string) {
        Element element = this.document.createElement(string);
        return new W3CDOMWrapper(element);
    }
}

