/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.ClickableExtension;
import com.tonbeller.jpivot.table.CellBuilder;
import com.tonbeller.jpivot.table.ClickableMember;
import com.tonbeller.jpivot.table.ColumnAxisBuilder;
import com.tonbeller.jpivot.table.CornerBuilder;
import com.tonbeller.jpivot.table.RowAxisBuilder;
import com.tonbeller.jpivot.table.SlicerBuilder;
import com.tonbeller.jpivot.table.TableComponentExtension;
import com.tonbeller.jpivot.table.span.PropertyConfig;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableComponent
extends ComponentSupport
implements ModelChangeListener {
    private static Logger logger = Logger.getLogger((Class)TableComponent.class);
    CellBuilder cellBuilder;
    CornerBuilder cornerBuilder;
    SlicerBuilder slicerBuilder;
    RowAxisBuilder rowAxisBuilder;
    ColumnAxisBuilder columnAxisBuilder;
    Resources resources;
    List extensionList = new ArrayList();
    Map extensionMap = new HashMap();
    OlapModel olapModel;
    Document document;
    Result result;
    Iterator cellIterator;
    int dimCount;
    Element rootElement;

    public TableComponent(String id, Component parent) {
        super(id, parent);
    }

    public TableComponent(String id, Component parent, OlapModel newOlapModel) {
        super(id, parent);
        logger.info((Object)"TableComponent");
        this.olapModel = newOlapModel;
        this.olapModel.addModelChangeListener(this);
    }

    public TableComponent() {
        super(null, null);
    }

    public void setOlapModel(OlapModel newOlapModel) {
        logger.info((Object)"setOlapModel");
        if (this.olapModel != null) {
            this.olapModel.removeModelChangeListener(this);
        }
        this.olapModel = newOlapModel;
        this.olapModel.addModelChangeListener(this);
    }

    public void initialize(RequestContext context) throws Exception {
        logger.info((Object)"initialize");
        super.initialize(context);
        this.resources = context.getResources(TableComponent.class);
        Iterator it = this.extensionList.iterator();
        while (it.hasNext()) {
            ((TableComponentExtension)it.next()).initialize(context, this);
        }
        this.columnAxisBuilder.initialize(context, this);
        this.rowAxisBuilder.initialize(context, this);
        this.cellBuilder.initialize(context, this);
        this.cornerBuilder.initialize(context, this);
        this.slicerBuilder.initialize(context, this);
    }

    public void destroy(HttpSession session) throws Exception {
        logger.info((Object)"destroy");
        this.slicerBuilder.destroy(session);
        this.cornerBuilder.destroy(session);
        this.cellBuilder.destroy(session);
        this.rowAxisBuilder.destroy(session);
        this.columnAxisBuilder.destroy(session);
        Iterator it = this.extensionList.iterator();
        while (it.hasNext()) {
            ((TableComponentExtension)it.next()).destroy(session);
        }
        super.destroy(session);
    }

    public Object getBookmarkState(int levelOfDetail) {
        logger.info((Object)"getBookmarkState");
        Map map = (Map)super.getBookmarkState(levelOfDetail);
        map.put("slicerBuilder", this.slicerBuilder.getBookmarkState(levelOfDetail));
        map.put("cornerBuilder", this.cornerBuilder.getBookmarkState(levelOfDetail));
        map.put("cellBuilder", this.cellBuilder.getBookmarkState(levelOfDetail));
        map.put("rowAxisBuilder", this.rowAxisBuilder.getBookmarkState(levelOfDetail));
        map.put("columnAxisBuilder", this.columnAxisBuilder.getBookmarkState(levelOfDetail));
        Iterator it = this.extensionList.iterator();
        while (it.hasNext()) {
            TableComponentExtension tce = (TableComponentExtension)it.next();
            map.put(tce.getId(), tce.getBookmarkState(levelOfDetail));
        }
        return map;
    }

    public void setBookmarkState(Object state) {
        if (state == null) {
            return;
        }
        logger.info((Object)"setBookmarkState");
        super.setBookmarkState(state);
        Map map = (Map)state;
        this.slicerBuilder.setBookmarkState(map.get("slicerBuilder"));
        this.cornerBuilder.setBookmarkState(map.get("cornerBuilder"));
        this.cellBuilder.setBookmarkState(map.get("cellBuilder"));
        this.rowAxisBuilder.setBookmarkState(map.get("rowAxisBuilder"));
        this.columnAxisBuilder.setBookmarkState(map.get("columnAxisBuilder"));
        Iterator it = this.extensionList.iterator();
        while (it.hasNext()) {
            TableComponentExtension tce = (TableComponentExtension)it.next();
            tce.setBookmarkState(map.get(tce.getId()));
        }
    }

    public Iterator clickableIterator() {
        ClickableExtension ce = (ClickableExtension)this.olapModel.getExtension("clickable");
        if (ce == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return ce.getClickables().iterator();
    }

    public void request(RequestContext context) throws Exception {
        super.request(context);
        Iterator it = this.clickableIterator();
        while (it.hasNext()) {
            ((RequestListener)it.next()).request(context);
        }
    }

    private void startBuild(RequestContext context) {
        logger.info((Object)"enter startBuild");
        this.columnAxisBuilder.startBuild(context);
        this.rowAxisBuilder.startBuild(context);
        this.cellBuilder.startBuild(context);
        this.cornerBuilder.startBuild(context);
        this.slicerBuilder.startBuild(context);
        Iterator it = this.extensionList.iterator();
        while (it.hasNext()) {
            ((TableComponentExtension)it.next()).startBuild(context);
        }
        it = this.clickableIterator();
        while (it.hasNext()) {
            ((ClickableMember)it.next()).startRendering(context, this);
        }
        logger.info((Object)"leave startBuild");
    }

    private void stopBuild() {
        logger.info((Object)"enter stopBuild");
        Iterator it = this.extensionList.iterator();
        while (it.hasNext()) {
            ((TableComponentExtension)it.next()).stopBuild();
        }
        this.slicerBuilder.stopBuild();
        this.cornerBuilder.stopBuild();
        this.cellBuilder.stopBuild();
        this.rowAxisBuilder.stopBuild();
        this.columnAxisBuilder.stopBuild();
        it = this.clickableIterator();
        while (it.hasNext()) {
            ((ClickableMember)it.next()).stopRendering();
        }
        this.result = null;
        this.cellIterator = null;
        logger.info((Object)"leave stopBuild");
    }

    public Document render(RequestContext context) throws Exception {
        logger.info((Object)"render");
        if (this.document == null) {
            logger.info((Object)"creating document");
            long t1 = System.currentTimeMillis();
            this.document = XmlUtils.createDocument();
            Element elem = this.render2(context);
            this.document.appendChild(elem);
            if (logger.isInfoEnabled()) {
                long t2 = System.currentTimeMillis();
                logger.info((Object)("Rendering of Table took " + (t2 - t1) + " millisec"));
            }
        }
        return this.document;
    }

    protected Result updateOlapModel() throws Exception {
        return this.olapModel.getResult();
    }

    private Element render2(RequestContext context) throws Exception {
        logger.info((Object)"render2");
        this.result = this.updateOlapModel();
        this.cellIterator = this.result.getCells().iterator();
        this.dimCount = this.result.getAxes().length;
        this.rootElement = this.document.createElement("mdxtable");
        Element head = this.append("head", this.rootElement);
        Element body = this.append("body", this.rootElement);
        this.startBuild(context);
        switch (this.dimCount) {
            case 0: {
                logger.info((Object)"0-dim data");
                this.buildRows0Dim(body);
                break;
            }
            case 1: {
                logger.info((Object)"1-dim data");
                this.buildColumns1Dim(head);
                this.buildRows1Dim(body);
                break;
            }
            case 2: {
                logger.info((Object)"2-dim data");
                this.buildColumns2Dim(head);
                this.buildRows2Dim(body);
                break;
            }
            default: {
                logger.error((Object)"more than 2 dimensions");
                throw new IllegalArgumentException("TableRenderer requires 0, 1 or 2 dimensional result");
            }
        }
        this.rootElement.appendChild(this.buildSlicer());
        this.stopBuild();
        return this.rootElement;
    }

    private Element buildSlicer() {
        logger.info((Object)"buildSlicer");
        Element slicer = this.elem("slicer");
        boolean gotOne = false;
        Iterator pi = this.getResult().getSlicer().getPositions().iterator();
        while (pi.hasNext()) {
            Position p = (Position)pi.next();
            Member[] members = p.getMembers();
            for (int i = 0; i < members.length; ++i) {
                Element e = this.slicerBuilder.build(members[i]);
                slicer.appendChild(e);
                gotOne = true;
            }
        }
        if (!gotOne) {
            Element empty = this.elem("empty");
            String v = null;
            try {
                v = this.resources.getString("jsp.jpivot.table.slicer.empty");
            }
            catch (MissingResourceException ex) {
                v = "EMPTY";
            }
            empty.setAttribute("value", v);
            slicer.appendChild(empty);
        }
        return slicer;
    }

    private void buildRows0Dim(Element parent) {
        logger.info((Object)"buildRows0Dim");
        if (!this.cellIterator.hasNext()) {
            return;
        }
        Element row = this.append("row", parent);
        Cell cell = (Cell)this.cellIterator.next();
        Element cellElem = this.cellBuilder.build(cell, true);
        row.appendChild(cellElem);
    }

    private void buildRows1Dim(Element parent) {
        logger.info((Object)"buildRows1Dim");
        Element row = this.append("row", parent);
        this.buildCells(row, false);
    }

    private void buildColumns1Dim(Element parent) {
        logger.info((Object)"buildColumns1Dim");
        int N = this.columnAxisBuilder.getRowCount();
        for (int i = 0; i < N; ++i) {
            Element row = this.append("row", parent);
            this.columnAxisBuilder.buildRow(row, i);
        }
    }

    private void buildCornerElement(Element parent, int colSpan, int rowSpan) {
        Element corner = this.cornerBuilder.build(colSpan, rowSpan);
        parent.appendChild(corner);
    }

    private void buildColumns2Dim(Element parent) {
        int i;
        Element row;
        int N;
        logger.info((Object)"enter buildColumns2Dim");
        int colAxisCount = this.columnAxisBuilder.getRowCount();
        int rowAxisCount = this.rowAxisBuilder.getHeaderRowCount();
        int colAxisIndex = 0;
        int rowAxisIndex = 0;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("colAxisCount = " + colAxisCount + ", rowAxisCount = " + rowAxisCount));
        }
        if (rowAxisCount > colAxisCount) {
            logger.info((Object)"rowAxisCount > colAxisCount");
            N = rowAxisCount - colAxisCount;
            row = this.append("row", parent);
            this.rowAxisBuilder.buildHeaderRow(row, rowAxisIndex++);
            this.buildCornerElement(row, this.columnAxisBuilder.getColumnCount(), N);
            for (i = 1; i < N; ++i) {
                row = this.append("row", parent);
                this.rowAxisBuilder.buildHeaderRow(row, rowAxisIndex++);
            }
            rowAxisCount -= N;
        } else if (colAxisCount > rowAxisCount) {
            logger.info((Object)"colAxisCount > rowAxisCount");
            N = colAxisCount - rowAxisCount;
            row = this.append("row", parent);
            this.buildCornerElement(row, this.rowAxisBuilder.getColumnCount(), N);
            this.columnAxisBuilder.buildRow(row, colAxisIndex++);
            for (i = 1; i < N; ++i) {
                row = this.append("row", parent);
                this.columnAxisBuilder.buildRow(row, colAxisIndex++);
            }
            colAxisCount -= N;
        }
        logger.info((Object)"building cells");
        for (int i2 = 0; i2 < colAxisCount; ++i2) {
            row = this.append("row", parent);
            this.rowAxisBuilder.buildHeaderRow(row, rowAxisIndex++);
            this.columnAxisBuilder.buildRow(row, colAxisIndex++);
        }
        logger.info((Object)"leave buildColumns2Dim");
    }

    private void buildRows2Dim(Element parent) {
        logger.info((Object)"enter buildRows2Dim");
        int cellCountLimit = Integer.getInteger("com.tonbeller.jpivot.mondrian.cell.limit", MondrianModel.CELL_LIMIT_DEFAULT);
        int nosRows = this.rowAxisBuilder.getRowCount();
        int nosColumns = this.columnAxisBuilder.getColumnCount();
        if (logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("buildRows2Dim: cellCountLimit=");
            buf.append(cellCountLimit);
            buf.append(", nosColumns=");
            buf.append(nosColumns);
            buf.append(", nosRows=");
            buf.append(nosRows);
            logger.debug((Object)buf.toString());
        }
        if (cellCountLimit > 0 && cellCountLimit < nosColumns * nosRows) {
            int nr = cellCountLimit / nosColumns + 1;
            if (logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("buildRows2Dim: number of rows=");
                buf.append(nr);
                logger.debug((Object)buf.toString());
            }
            for (int i = 0; i < nr; ++i) {
                boolean even = i % 2 == 0;
                Element row = this.append("row", parent);
                this.rowAxisBuilder.buildRow(row, i);
                this.buildCells(row, even);
            }
            Element row = this.append("row", parent);
            this.rowAxisBuilder.buildRow(row, nr);
            Element cellElem = this.elem("cellspan");
            String v = null;
            try {
                v = this.resources.getString("jsp.jpivot.table.cell.limit", (Object)new Integer(cellCountLimit), (Object)new Integer(nosColumns * nosRows));
            }
            catch (MissingResourceException ex) {
                v = "Too many cells (cell limit:" + cellCountLimit + ")";
            }
            cellElem.setAttribute("value", v);
            cellElem.setAttribute("colspan", Integer.toString(nosColumns));
            row.appendChild(cellElem);
        } else {
            for (int i = 0; i < nosRows; ++i) {
                boolean even = i % 2 == 0;
                Element row = this.append("row", parent);
                this.rowAxisBuilder.buildRow(row, i);
                this.buildCells(row, even);
            }
        }
        logger.info((Object)"leave buildRows2Dim");
    }

    private void buildCells(Element row, boolean even) {
        int N = this.columnAxisBuilder.getColumnCount();
        for (int i = 0; i < N; ++i) {
            try {
                Cell cell = (Cell)this.cellIterator.next();
                Element cellElem = this.cellBuilder.build(cell, even);
                row.appendChild(cellElem);
                continue;
            }
            catch (NoSuchElementException e) {
                logger.error((Object)"not enough cells", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    public Element elem(String name) {
        return this.document.createElement(name);
    }

    public Element append(String name, Element parent) {
        Element elem = this.document.createElement(name);
        parent.appendChild(elem);
        return elem;
    }

    private void firstChild(Element child, Element parent) {
        Node before = parent.getFirstChild();
        if (before != null) {
            parent.insertBefore(child, before);
        } else {
            parent.appendChild(child);
        }
    }

    public Element insert(String name, Element parent) {
        Element elem = this.document.createElement(name);
        this.firstChild(elem, parent);
        return elem;
    }

    public Object cdata(String content, Element parent) {
        CDATASection section = this.document.createCDATASection(content);
        parent.appendChild(section);
        return section;
    }

    public OlapModel getOlapModel() {
        return this.olapModel;
    }

    public void addExtension(TableComponentExtension extension) {
        this.extensionList.add(extension);
        this.extensionMap.put(extension.getId(), extension);
    }

    public Map getExtensions() {
        return this.extensionMap;
    }

    public boolean isDirty() {
        return this.document == null;
    }

    public void setDirty(boolean dirty) {
        this.document = null;
        this.result = null;
        this.cellIterator = null;
        this.rootElement = null;
    }

    public void modelChanged(ModelChangeEvent e) {
        this.setDirty(true);
    }

    public void structureChanged(ModelChangeEvent e) {
        this.setDirty(true);
    }

    public CellBuilder getCellBuilder() {
        return this.cellBuilder;
    }

    public ColumnAxisBuilder getColumnAxisBuilder() {
        return this.columnAxisBuilder;
    }

    public CornerBuilder getCornerBuilder() {
        return this.cornerBuilder;
    }

    public RowAxisBuilder getRowAxisBuilder() {
        return this.rowAxisBuilder;
    }

    public SlicerBuilder getSlicerBuilder() {
        return this.slicerBuilder;
    }

    public void setCellBuilder(CellBuilder cellBuilder) {
        this.cellBuilder = cellBuilder;
    }

    public void setColumnAxisBuilder(ColumnAxisBuilder columnAxisBuilder) {
        this.columnAxisBuilder = columnAxisBuilder;
    }

    public void setCornerBuilder(CornerBuilder cornerBuilder) {
        this.cornerBuilder = cornerBuilder;
    }

    public void setRowAxisBuilder(RowAxisBuilder rowAxisBuilder) {
        this.rowAxisBuilder = rowAxisBuilder;
    }

    public void setSlicerBuilder(SlicerBuilder slicerBuilder) {
        this.slicerBuilder = slicerBuilder;
    }

    public Result getResult() {
        return this.result;
    }

    public int getDimCount() {
        return this.dimCount;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public Axis getRowAxis() {
        if (this.dimCount < 2) {
            return null;
        }
        return this.result.getAxes()[1];
    }

    public Axis getColumnAxis() {
        if (this.dimCount < 1) {
            return null;
        }
        return this.result.getAxes()[0];
    }

    public PropertyConfig getPropertyConfig() {
        return this.rowAxisBuilder.getAxisConfig().getPropertyConfig();
    }
}

