/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.SortRank;
import com.tonbeller.jpivot.table.ColumnAxisBuilder;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.SpanBuilderDecorator;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.TableComponentExtensionSupport;
import com.tonbeller.jpivot.table.navi.AxisStyleUI;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.utils.DomUtils;
import org.w3c.dom.Element;

public class SortRankUI
extends TableComponentExtensionSupport
implements ModelChangeListener {
    public static final String ID = "sortRank";
    Dispatcher dispatcher = new DispatcherSupport();
    private boolean triState = true;
    Resources resources;
    SortRank extension;
    boolean renderActions;

    public String getId() {
        return ID;
    }

    public void initialize(RequestContext context, TableComponent table) throws Exception {
        super.initialize(context, table);
        table.getOlapModel().addModelChangeListener(this);
        this.extension = this.getExtension();
        table.getDispatcher().addRequestListener(null, null, (RequestListener)this.dispatcher);
        ColumnAxisBuilder cab = table.getColumnAxisBuilder();
        DomDecorator chr = new DomDecorator(cab.getSpanBuilder());
        cab.setSpanBuilder(chr);
        this.resources = Resources.instance();
        if (this.resources == null) {
            this.resources = context.getResources(SortRankUI.class);
        }
    }

    public void startBuild(RequestContext context) {
        super.startBuild(context);
        this.renderActions = RendererParameters.isRenderActions((RequestContext)context);
        if (this.renderActions) {
            this.dispatcher.clear();
        }
    }

    public boolean isAvailable() {
        SortRank ext = this.getExtension();
        return ext != null && !(ext instanceof DummySortRank);
    }

    boolean isTopBottomCount() {
        int mode = this.extension.getSortMode();
        return mode == 5 || mode == 6;
    }

    boolean isAscending() {
        int mode = this.extension.getSortMode();
        return mode == 1 || mode == 3 || mode == 6;
    }

    void flipAscending() {
        int mode = this.extension.getSortMode();
        switch (mode) {
            case 1: {
                mode = 2;
                break;
            }
            case 2: {
                mode = 1;
                break;
            }
            case 3: {
                mode = 4;
                break;
            }
            case 4: {
                mode = 3;
                break;
            }
            case 5: {
                mode = 6;
                break;
            }
            case 6: {
                mode = 5;
            }
        }
        this.extension.setSortMode(mode);
    }

    public int getSortMode() {
        return this.extension.getSortMode();
    }

    public int getTopBottomCount() {
        return this.extension.getTopBottomCount();
    }

    public boolean isSorting() {
        return this.extension.isSorting();
    }

    public void setSorting(boolean enabled) {
        this.extension.setSorting(enabled);
    }

    public void setSortMode(int mode) {
        this.extension.setSortMode(mode);
        AxisStyleUI asu = (AxisStyleUI)this.table.getExtensions().get("axisStyle");
        if (asu == null) {
            return;
        }
        if (mode == 1 || mode == 2) {
            asu.setLevelStyle(false);
        } else {
            asu.setLevelStyle(true);
        }
    }

    public void setTopBottomCount(int topBottomCount) {
        this.extension.setTopBottomCount(topBottomCount);
    }

    public boolean isTriState() {
        return this.triState;
    }

    public void setTriState(boolean triState) {
        this.triState = triState;
    }

    private SortRank getExtension() {
        SortRank ext = (SortRank)this.table.getOlapModel().getExtension(ID);
        if (ext == null) {
            ext = new DummySortRank();
        }
        return ext;
    }

    public void modelChanged(ModelChangeEvent e) {
    }

    public void structureChanged(ModelChangeEvent e) {
        this.extension = this.getExtension();
        this.dispatcher.clear();
    }

    public boolean isBreakHierarchy() {
        switch (this.extension.getSortMode()) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void setBreakHierarchy(boolean b) {
        if (b) {
            this.setSortMode(4);
        }
    }

    public boolean isKeepHierarchy() {
        switch (this.extension.getSortMode()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void setKeepHierarchy(boolean b) {
        if (b) {
            this.setSortMode(2);
        }
    }

    public boolean isRanking() {
        switch (this.extension.getSortMode()) {
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void setRanking(boolean b) {
        if (b) {
            this.setSortMode(5);
        }
    }

    private class SortHandler2
    implements RequestListener {
        Position position;
        Axis axis;

        SortHandler2(Position position, Axis axis) {
            this.position = (Position)position.getRootDecoree();
            this.axis = (Axis)axis.getRootDecoree();
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            if (SortRankUI.this.extension.isCurrentSorting(this.position)) {
                SortRankUI.this.flipAscending();
            }
            SortRankUI.this.extension.sort(this.axis, this.position);
        }
    }

    private class SortHandler3
    implements RequestListener {
        Position position;
        Axis axis;

        SortHandler3(Position position, Axis axis) {
            this.position = (Position)position.getRootDecoree();
            this.axis = (Axis)axis.getRootDecoree();
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            if (!SortRankUI.this.extension.isSorting()) {
                SortRankUI.this.extension.setSorting(true);
                SortRankUI.this.extension.sort(this.axis, this.position);
                return;
            }
            if (!SortRankUI.this.extension.isCurrentSorting(this.position)) {
                SortRankUI.this.extension.sort(this.axis, this.position);
                return;
            }
            if (SortRankUI.this.isAscending() || SortRankUI.this.isTopBottomCount()) {
                SortRankUI.this.flipAscending();
                SortRankUI.this.extension.sort(this.axis, this.position);
                return;
            }
            SortRankUI.this.flipAscending();
            SortRankUI.this.extension.setSorting(false);
        }
    }

    class DomDecorator
    extends SpanBuilderDecorator {
        DomDecorator(SpanBuilder delegate) {
            super(delegate);
        }

        public Element build(SpanBuilder.SBContext sbctx, Span span, boolean even) {
            Element parent = super.build(sbctx, span, even);
            if (!SortRankUI.this.isEnabled() || !SortRankUI.this.renderActions) {
                return parent;
            }
            if (!SortRankUI.this.triState && !SortRankUI.this.extension.isSorting()) {
                return parent;
            }
            if (!span.isMember()) {
                return parent;
            }
            Member member = span.getMember();
            Position position = span.getPosition();
            if (!this.isCandidate(position, member)) {
                return parent;
            }
            Axis axis = span.getAxis();
            Axis[] axes = this.table.getResult().getAxes();
            if (axes.length < 2) {
                return parent;
            }
            axis = axes[0].getRootDecoree().equals(axis.getRootDecoree()) ? axes[1] : axes[0];
            Element sort = this.table.insert("sort", parent);
            String id = DomUtils.randomId();
            sort.setAttribute("id", id);
            if (SortRankUI.this.triState) {
                SortRankUI.this.dispatcher.addRequestListener(id, null, (RequestListener)new SortHandler3(position, axis));
            } else {
                SortRankUI.this.dispatcher.addRequestListener(id, null, (RequestListener)new SortHandler2(position, axis));
            }
            sort.setAttribute("title", SortRankUI.this.resources.getString("jsp.jpivot.sort.mode." + SortRankUI.this.extension.getSortMode()));
            if (!SortRankUI.this.extension.isSorting()) {
                sort.setAttribute("mode", "sort-natural");
                sort.setAttribute("title", SortRankUI.this.resources.getString("jsp.jpivot.sort.mode.natural"));
            } else if (SortRankUI.this.extension.isCurrentSorting((Position)position.getRootDecoree())) {
                if (SortRankUI.this.isAscending()) {
                    sort.setAttribute("mode", "sort-current-up");
                } else {
                    sort.setAttribute("mode", "sort-current-down");
                }
            } else if (SortRankUI.this.isAscending()) {
                sort.setAttribute("mode", "sort-other-up");
            } else {
                sort.setAttribute("mode", "sort-other-down");
            }
            return parent;
        }

        boolean isCandidate(Position position, Member member) {
            Member[] members = position.getMembers();
            if (!((Object)member).equals(members[members.length - 1])) {
                return false;
            }
            return SortRankUI.this.extension.isSortable((Position)position.getRootDecoree());
        }
    }

    class DummySortRank
    implements SortRank {
        DummySortRank() {
        }

        public boolean isSorting() {
            return false;
        }

        public void setSorting(boolean enabled) {
        }

        public boolean isSortable(Position position) {
            return false;
        }

        public boolean isCurrentSorting(Position position) {
            return false;
        }

        public int getSortMode() {
            return 1;
        }

        public void setSortMode(int mode) {
        }

        public int getTopBottomCount() {
            return 10;
        }

        public void setTopBottomCount(int topBottomCount) {
        }

        public void sort(Axis membersToSort, Position position) throws OlapException {
        }

        public void setModel(Model model) {
        }

        public String getId() {
            return SortRankUI.ID;
        }

        public Model decorate(Model modelToDecorate) {
            return modelToDecorate;
        }

        public void modelInitialized() {
        }
    }
}

