/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.olap.model.DoubleExpr;
import com.tonbeller.jpivot.olap.model.Expression;
import com.tonbeller.jpivot.olap.model.IntegerExpr;
import com.tonbeller.jpivot.olap.model.StringExpr;
import com.tonbeller.jpivot.olap.navi.SetParameter;
import com.tonbeller.tbutils.res.Resources;
import java.util.Hashtable;
import java.util.Map;
import mondrian.olap.Member;
import mondrian.olap.Parameter;
import mondrian.olap.Query;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import org.apache.log4j.Logger;

public class MondrianSetParameter
extends ExtensionSupport
implements SetParameter {
    static Logger logger = Logger.getLogger((Class)MondrianSetParameter.class);
    Resources resources = Resources.instance();

    public MondrianSetParameter() {
        super.setId("setParameter");
    }

    public void setParameter(String paramName, Expression expr) {
        MondrianModel model = (MondrianModel)this.getModel();
        Query monQuery = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
        Parameter[] monParams = monQuery.getParameters();
        for (int i = 0; i < monParams.length; ++i) {
            Parameter monParam = monParams[i];
            int pType = TypeUtil.typeToCategory((Type)monParam.getType());
            String monParaName = monParam.getName();
            if (!paramName.equals(monParaName)) continue;
            switch (pType) {
                case 7: {
                    if (expr instanceof DoubleExpr) {
                        double d = ((DoubleExpr)expr).getValue();
                        monParam.setValue((Object)new Double(d));
                        break;
                    }
                    if (expr instanceof IntegerExpr) {
                        int ii = ((IntegerExpr)expr).getValue();
                        monParam.setValue((Object)new Double(ii));
                        break;
                    }
                    String str = this.resources.getString("jpivot.MondrianSetParameter.error.wrongNumericParameter") + paramName + expr.getClass().toString();
                    logger.error((Object)str);
                    throw new IllegalArgumentException(str);
                }
                case 9: {
                    if (expr instanceof StringExpr) {
                        String s = ((StringExpr)expr).getValue();
                        monParam.setValue((Object)s);
                        break;
                    }
                    String str = this.resources.getString("jpivot.MondrianSetParameter.error.wrongStringParameter") + paramName + expr.getClass().toString();
                    logger.error((Object)str);
                    throw new IllegalArgumentException(str);
                }
                case 6: {
                    if (expr instanceof MondrianMember) {
                        MondrianMember m = (MondrianMember)expr;
                        monParam.setValue((Object)m.getMonMember());
                        break;
                    }
                    String str = this.resources.getString("jpivot.MondrianSetParameter.error.wrongMemberParameter") + paramName + expr.getClass().toString();
                    logger.error((Object)str);
                    throw new IllegalArgumentException(str);
                }
            }
            model.fireModelChanged();
            return;
        }
    }

    public Map getDisplayValues() {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        MondrianModel model = (MondrianModel)this.getModel();
        Query monQuery = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
        Parameter[] monParams = monQuery.getParameters();
        block5: for (int i = 0; i < monParams.length; ++i) {
            Parameter monParam = monParams[i];
            int pType = TypeUtil.typeToCategory((Type)monParam.getType());
            String monParaName = monParam.getName();
            Object value = monParam.getValue();
            switch (pType) {
                case 7: {
                    map.put(monParaName, value.toString());
                    continue block5;
                }
                case 9: {
                    map.put(monParaName, value);
                    continue block5;
                }
                case 6: {
                    map.put(monParaName, ((Member)value).getCaption());
                }
            }
        }
        return map;
    }

    public String[] getParameterNames() {
        MondrianModel model = (MondrianModel)this.getModel();
        Query monQuery = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
        Parameter[] monParams = monQuery.getParameters();
        String[] names = new String[monParams.length];
        for (int i = 0; i < monParams.length; ++i) {
            names[i] = monParams[i].getName();
        }
        return names;
    }

    public boolean getHasDisplayValues() {
        MondrianModel model = (MondrianModel)this.getModel();
        Query monQuery = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
        Parameter[] monParams = monQuery.getParameters();
        return monParams.length > 0;
    }
}

