/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.member;

import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.wcf.tree.AbstractTreeModel;
import com.tonbeller.wcf.tree.TreeModel;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TreeModelAdapter
extends AbstractTreeModel
implements TreeModel {
    Hierarchy[] hiers;
    MemberTree tree;
    Level noChildrenLevel = null;
    Locale locale;
    boolean showSingleHierarchyNode = false;
    OverflowListener overflowListener;
    private static Logger logger = Logger.getLogger((Class)TreeModelAdapter.class);

    public TreeModelAdapter(Hierarchy hier, MemberTree tree, Locale locale) {
        this.hiers = new Hierarchy[]{hier};
        this.tree = tree;
        this.locale = locale;
    }

    public TreeModelAdapter(Hierarchy[] hiers, MemberTree tree, Locale locale) {
        this.hiers = hiers;
        this.tree = tree;
        this.locale = locale;
    }

    public Object[] getRoots() {
        try {
            if (this.showSingleHierarchyNode || this.hiers.length > 1) {
                return this.hiers;
            }
            return this.tree.getRootMembers(this.hiers[0]);
        }
        catch (MemberTree.TooManyMembersException e) {
            this.overflowOccured(e);
            return new Member[0];
        }
    }

    public boolean hasChildren(Object node) {
        Member m;
        if (node instanceof Hierarchy) {
            return true;
        }
        if (this.noChildrenLevel != null && this.noChildrenLevel.equals((m = (Member)node).getLevel())) {
            return false;
        }
        return this.tree.hasChildren((Member)node);
    }

    public Object[] getChildren(Object node) {
        try {
            if (node instanceof Hierarchy) {
                return this.tree.getRootMembers((Hierarchy)node);
            }
            Object[] children = this.tree.getChildren((Member)node);
            if (children == null) {
                return new Member[0];
            }
            return children;
        }
        catch (MemberTree.TooManyMembersException e) {
            this.overflowOccured(e);
            return new Member[0];
        }
    }

    public Object getParent(Object node) {
        if (this.showSingleHierarchyNode || this.hiers.length > 1) {
            if (node instanceof Hierarchy) {
                return null;
            }
            Member parent = this.tree.getParent((Member)node);
            if (parent == null) {
                return ((Member)node).getLevel().getHierarchy();
            }
            return parent;
        }
        return this.tree.getParent((Member)node);
    }

    public void fireModelChanged() {
        super.fireModelChanged();
    }

    public Level getNoChildrenLevel() {
        return this.noChildrenLevel;
    }

    public void setNoChildrenLevel(Level level) {
        this.noChildrenLevel = level;
    }

    public void modelChanged() {
        super.fireModelChanged();
    }

    private void overflowOccured(Exception e) {
        logger.error(null, (Throwable)e);
        if (this.overflowListener != null) {
            this.overflowListener.overflowOccured();
        }
    }

    public OverflowListener getOverflowListener() {
        return this.overflowListener;
    }

    public void setOverflowListener(OverflowListener overflowListener) {
        this.overflowListener = overflowListener;
    }

    public boolean isShowSingleHierarchyNode() {
        return this.showSingleHierarchyNode;
    }

    public void setShowSingleHierarchyNode(boolean showSingleHierarchyNode) {
        this.showSingleHierarchyNode = showSingleHierarchyNode;
    }

    static interface OverflowListener {
        public void overflowOccured();
    }
}

