/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.table.ColumnAxisBuilder;
import com.tonbeller.jpivot.table.RowAxisBuilder;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.SpanBuilderDecorator;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.TableComponentExtensionSupport;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.utils.DomUtils;
import org.w3c.dom.Element;

public abstract class DrillExpandUI
extends TableComponentExtensionSupport
implements ModelChangeListener {
    boolean available;
    boolean renderActions;
    Dispatcher dispatcher = new DispatcherSupport();

    public void initialize(RequestContext context, TableComponent table) throws Exception {
        super.initialize(context, table);
        table.getOlapModel().addModelChangeListener(this);
        this.available = this.initializeExtension();
        table.getDispatcher().addRequestListener(null, null, (RequestListener)this.dispatcher);
        RowAxisBuilder rab = table.getRowAxisBuilder();
        DomDecorator rhr = new DomDecorator(rab.getSpanBuilder());
        rab.setSpanBuilder(rhr);
        ColumnAxisBuilder cab = table.getColumnAxisBuilder();
        DomDecorator chr = new DomDecorator(cab.getSpanBuilder());
        cab.setSpanBuilder(chr);
    }

    public void startBuild(RequestContext context) {
        super.startBuild(context);
        this.renderActions = RendererParameters.isRenderActions((RequestContext)context);
        if (this.renderActions) {
            this.dispatcher.clear();
        }
    }

    protected abstract boolean initializeExtension();

    protected abstract boolean canExpand(Span var1);

    protected abstract void expand(Span var1);

    protected abstract boolean canCollapse(Span var1);

    protected abstract void collapse(Span var1);

    protected abstract String getExpandImage();

    protected abstract String getCollapseImage();

    protected abstract String getOtherImage();

    public boolean isAvailable() {
        return this.available;
    }

    static int indexOf(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    static boolean positionContainsMember(Span s) {
        if (!s.isMember()) {
            return false;
        }
        Member m = (Member)s.getMember().getRootDecoree();
        Position p = (Position)s.getPosition().getRootDecoree();
        return DrillExpandUI.indexOf(p.getMembers(), m) >= 0;
    }

    public void modelChanged(ModelChangeEvent e) {
    }

    public void structureChanged(ModelChangeEvent e) {
        this.available = this.initializeExtension();
        this.dispatcher.clear();
    }

    class CollapseHandler
    implements RequestListener {
        Span span;

        CollapseHandler(Span span) {
            this.span = span;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            if (DrillExpandUI.this.canCollapse(this.span)) {
                DrillExpandUI.this.collapse(this.span);
            }
        }
    }

    class ExpandHandler
    implements RequestListener {
        Span span;

        ExpandHandler(Span span) {
            this.span = span;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            if (DrillExpandUI.this.canExpand(this.span)) {
                DrillExpandUI.this.expand(this.span);
            }
        }
    }

    class DomDecorator
    extends SpanBuilderDecorator {
        DomDecorator(SpanBuilder delegate) {
            super(delegate);
        }

        public Element build(SpanBuilder.SBContext sbctx, Span span, boolean even) {
            Element parent = super.build(sbctx, span, even);
            if (!(DrillExpandUI.this.enabled && DrillExpandUI.this.renderActions && DrillExpandUI.this.available)) {
                return parent;
            }
            String id = DomUtils.randomId();
            if (DrillExpandUI.this.canExpand(span)) {
                Element elem = this.table.insert("drill-expand", parent);
                elem.setAttribute("id", id);
                elem.setAttribute("img", DrillExpandUI.this.getExpandImage());
                DrillExpandUI.this.dispatcher.addRequestListener(id, null, (RequestListener)new ExpandHandler(span));
            } else if (DrillExpandUI.this.canCollapse(span)) {
                Element elem = this.table.insert("drill-collapse", parent);
                elem.setAttribute("id", id);
                elem.setAttribute("img", DrillExpandUI.this.getCollapseImage());
                DrillExpandUI.this.dispatcher.addRequestListener(id, null, (RequestListener)new CollapseHandler(span));
            } else {
                Element elem = this.table.insert("drill-other", parent);
                elem.setAttribute("img", DrillExpandUI.this.getOtherImage());
            }
            return parent;
        }
    }
}

