/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.VisitorSupportSloppy;
import com.tonbeller.jpivot.olap.navi.DrillReplace;
import com.tonbeller.jpivot.table.navi.DrillExpandUI;
import com.tonbeller.jpivot.table.span.PropertyHeading;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanVisitor;

public class DrillReplaceUI
extends DrillExpandUI {
    public static final String ID = "drillReplace";
    DrillReplace extension;

    public String getId() {
        return ID;
    }

    protected boolean canCollapse(Span span) {
        CanCollapse cc = new CanCollapse();
        span.getObject().accept(cc);
        return cc.result;
    }

    protected void collapse(Span span) {
        DoCollapse dc = new DoCollapse();
        span.getObject().accept(dc);
    }

    protected boolean canExpand(Span span) {
        if (DrillReplaceUI.positionContainsMember(span)) {
            return this.extension.canDrillDown((Member)span.getMember().getRootDecoree());
        }
        return false;
    }

    protected void expand(Span span) {
        this.extension.drillDown((Member)span.getMember().getRootDecoree());
    }

    protected boolean initializeExtension() {
        OlapModel om = this.table.getOlapModel();
        this.extension = (DrillReplace)om.getExtension(ID);
        return this.extension != null;
    }

    protected String getCollapseImage() {
        return "drill-replace-collapse";
    }

    protected String getExpandImage() {
        return "drill-replace-expand";
    }

    protected String getOtherImage() {
        return "drill-replace-other";
    }

    class DoCollapse
    extends VisitorSupportSloppy
    implements SpanVisitor {
        DoCollapse() {
        }

        public void visitHierarchy(Hierarchy v) {
            DrillReplaceUI.this.extension.drillUp(v);
        }

        public void visitLevel(Level v) {
            DrillReplaceUI.this.extension.drillUp(v.getHierarchy());
        }

        public void visitPropertyHeading(PropertyHeading heading) {
        }
    }

    class CanCollapse
    extends VisitorSupportSloppy
    implements SpanVisitor {
        boolean result = false;

        CanCollapse() {
        }

        public void visitHierarchy(Hierarchy v) {
            this.result = DrillReplaceUI.this.extension.canDrillUp(v);
        }

        public void visitLevel(Level v) {
            this.result = DrillReplaceUI.this.extension.canDrillUp(v.getHierarchy());
        }

        public void visitPropertyHeading(PropertyHeading heading) {
        }
    }
}

