/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.span;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.MemberPropertyMeta;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.impl.PropertyImpl;
import com.tonbeller.jpivot.olap.navi.MemberProperties;
import com.tonbeller.jpivot.table.span.MemberPropertyMetaFilter;
import com.tonbeller.jpivot.table.span.PropertyConfig;
import com.tonbeller.jpivot.table.span.PropertyUtils;
import com.tonbeller.jpivot.table.span.ScopedPropertyMetaSet;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanCalc;
import com.tonbeller.jpivot.ui.Available;
import com.tonbeller.wcf.controller.RequestContext;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class PropertySpanBuilder
implements PropertyConfig,
ModelChangeListener,
Available {
    private MemberProperties extension;
    private OlapModel model;
    private List[] propertyColumns;
    private int PCOUNT;
    private int HCOUNT;
    private SpanCalc spanCalc;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static Logger logger = Logger.getLogger((Class)PropertySpanBuilder.class);
    private List visiblePropertyMetas = null;
    private boolean showProperties = false;
    private Map emptyPropertyMap = new HashMap();
    private ScopedPropertyMetaSet metaSet;
    private AllPropertiesMap allPropertiesMap;

    PropertySpanBuilder(MemberProperties extension) {
        this.model = null;
        this.extension = extension;
    }

    public PropertySpanBuilder(OlapModel model) {
        this.model = model;
        this.extension = (MemberProperties)model.getExtension("memberProperties");
    }

    public void initialize(RequestContext context) {
        this.model.addModelChangeListener(this);
    }

    public void destroy(HttpSession session) {
        this.model.removeModelChangeListener(this);
    }

    public void modelChanged(ModelChangeEvent e) {
    }

    public void structureChanged(ModelChangeEvent e) {
        this.extension = (MemberProperties)this.model.getExtension("memberProperties");
        this.setVisiblePropertyMetas(null);
        this.setShowProperties(false);
    }

    public boolean isAvailable() {
        return this.model.getExtension("memberProperties") != null;
    }

    private void reset(SpanCalc spanCalc) {
        this.emptyPropertyMap.clear();
        this.allPropertiesMap = new AllPropertiesMap();
        this.metaSet = new ScopedPropertyMetaSet(this.extension);
        this.spanCalc = spanCalc;
        this.HCOUNT = spanCalc.getHierarchyCount();
        this.PCOUNT = spanCalc.getPositionCount();
        this.collectProperties();
        this.initializePropertyColumns();
    }

    void collectProperties() {
        Span[][] spans = this.spanCalc.getSpans();
        for (int hi = 0; hi < this.HCOUNT; ++hi) {
            for (int pi = 0; pi < this.PCOUNT; ++pi) {
                Span s = spans[pi][hi];
                if (!s.isMember()) continue;
                Member m = s.getMember();
                this.metaSet.addMember(m);
                this.allPropertiesMap.add(m);
            }
        }
    }

    void initializePropertyColumns() {
        this.propertyColumns = new List[this.HCOUNT];
        for (int i = 0; i < this.HCOUNT; ++i) {
            this.propertyColumns[i] = Collections.EMPTY_LIST;
        }
        if (this.PCOUNT == 0) {
            return;
        }
        Set[] scopes = new Set[this.HCOUNT];
        Span[][] spans = this.spanCalc.getSpans();
        for (int hi = 0; hi < this.HCOUNT; ++hi) {
            HashSet<Object> set = new HashSet<Object>();
            for (int pi = 0; pi < this.PCOUNT; ++pi) {
                set.add(this.getScope(spans[pi][hi]));
            }
            scopes[hi] = set;
        }
        HashSet done = new HashSet();
        for (int hi = 0; hi < this.HCOUNT; ++hi) {
            MemberPropertyMetaFilter scopesFilter = this.metaSet.createScopesFilter(scopes[hi]);
            MemberPropertyMetaFilter inlineFilter = this.metaSet.createIgnoreInlineFilter();
            if (hi != this.HCOUNT - 1 && ((Object)scopes[hi]).equals(scopes[hi + 1])) continue;
            ScopedPropertyMetaSet sub = this.metaSet.metaSet(scopesFilter);
            sub.removeAll(done);
            this.propertyColumns[hi] = this.visiblePropertyMetas == null ? sub.metaList(inlineFilter) : sub.intersectList(this.visiblePropertyMetas);
            done.addAll(this.propertyColumns[hi]);
        }
    }

    Object getScope(Span s) {
        if (!s.isMember()) {
            return s;
        }
        return this.extension.getPropertyScope((Member)s.getMember().getRootDecoree());
    }

    public void addPropertySpans(SpanCalc sc) {
        if (this.extension == null || !this.showProperties) {
            return;
        }
        logger.info((Object)"adding properties");
        this.reset(sc);
        int newHierCount = this.spanCalc.getHierarchyCount();
        for (int hi = 0; hi < this.HCOUNT; ++hi) {
            newHierCount += this.propertyColumns[hi].size();
        }
        Span[][] dst = new Span[this.PCOUNT][];
        for (int pi = 0; pi < this.PCOUNT; ++pi) {
            dst[pi] = new Span[newHierCount];
        }
        Span[][] src = this.spanCalc.getSpans();
        PropertyLookup lookup = new PropertyLookup();
        for (int pi = 0; pi < this.PCOUNT; ++pi) {
            int dstHierIndex = 0;
            lookup.clear();
            for (int hi = 0; hi < this.HCOUNT; ++hi) {
                Span span = src[pi][hi];
                dst[pi][dstHierIndex++] = span;
                if (span.isMember()) {
                    lookup.addAll(this.allPropertiesMap.getProperties(span.getMember()));
                }
                Object scope = this.getScope(span);
                Iterator it = this.propertyColumns[hi].iterator();
                while (it.hasNext()) {
                    MemberPropertyMeta mpm = (MemberPropertyMeta)it.next();
                    Property prop = null;
                    if (mpm.getScope().equals(scope)) {
                        prop = lookup.getProperty(mpm.getName());
                    }
                    if (prop == null) {
                        prop = this.emptyProperty(mpm.getName(), mpm.getLabel());
                    }
                    dst[pi][dstHierIndex++] = new Span(span.getAxis(), span.getPosition(), prop);
                }
            }
        }
        this.spanCalc.setSpans(dst);
    }

    Property emptyProperty(String name, String label) {
        Property p = (Property)this.emptyPropertyMap.get(name);
        if (p != null) {
            return p;
        }
        PropertyImpl pi = new PropertyImpl();
        pi.setName(name);
        pi.setLabel(label);
        pi.setValue("");
        this.emptyPropertyMap.put(name, pi);
        return pi;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean b) {
        Boolean oldValue = new Boolean(this.showProperties);
        this.showProperties = b;
        this.setVisiblePropertiesExtension();
        Boolean newValue = new Boolean(this.showProperties);
        this.propertyChangeSupport.firePropertyChange("showProperties", oldValue, newValue);
    }

    public void setVisiblePropertyMetas(List metas) {
        List oldValue = this.visiblePropertyMetas;
        this.visiblePropertyMetas = metas;
        this.setVisiblePropertiesExtension();
        List newValue = this.visiblePropertyMetas;
        this.propertyChangeSupport.firePropertyChange("visiblePropertyMetas", oldValue, newValue);
    }

    public List getVisiblePropertyMetas() {
        return this.visiblePropertyMetas;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public Object getBookmarkState(int levelOfDetail) {
        BookmarkState x = new BookmarkState();
        x.setShowProperties(this.isShowProperties());
        if (this.visiblePropertyMetas != null) {
            ArrayList metas = new ArrayList();
            metas.addAll(this.visiblePropertyMetas);
            x.setVisibleProperties(metas);
        }
        return x;
    }

    public void setBookmarkState(Object state) {
        if (!(state instanceof BookmarkState)) {
            return;
        }
        BookmarkState x = (BookmarkState)state;
        this.setVisiblePropertyMetas(x.getVisibleProperties());
        this.setShowProperties(x.isShowProperties());
    }

    protected void setVisiblePropertiesExtension() {
        if (this.extension == null) {
            return;
        }
        if (!this.showProperties || this.visiblePropertyMetas == null) {
            this.extension.setVisibleProperties(new MemberPropertyMeta[0]);
            return;
        }
        MemberPropertyMeta[] mps = new MemberPropertyMeta[this.visiblePropertyMetas.size()];
        mps = this.visiblePropertyMetas.toArray(mps);
        this.extension.setVisibleProperties(mps);
    }

    public static class BookmarkState {
        boolean showProperties = false;
        List visibleProperties = null;

        public boolean isShowProperties() {
            return this.showProperties;
        }

        public List getVisibleProperties() {
            return this.visibleProperties;
        }

        public void setShowProperties(boolean b) {
            this.showProperties = b;
        }

        public void setVisibleProperties(List list) {
            this.visibleProperties = list;
        }
    }

    class PropertyLookup {
        Map map = new HashMap();

        PropertyLookup() {
        }

        void clear() {
            this.map.clear();
        }

        void addAll(Collection properties) {
            Iterator it = properties.iterator();
            while (it.hasNext()) {
                Property p = (Property)it.next();
                this.map.put(p.getName(), p);
            }
        }

        Property getProperty(String name) {
            return (Property)this.map.get(name);
        }
    }

    static class AllPropertiesMap {
        private Map map = new HashMap();
        private Set set = new HashSet();

        AllPropertiesMap() {
        }

        void add(Member member) {
            if (member == null) {
                return;
            }
            if (this.set.contains(member)) {
                return;
            }
            this.set.add(member);
            Property[] props = member.getProperties();
            props = PropertyUtils.normalize(props);
            ArrayList<Property> list = new ArrayList<Property>();
            for (int i = 0; i < props.length; ++i) {
                Property p = props[i];
                if (PropertyUtils.isInline(p.getName())) continue;
                list.add(p);
            }
            this.map.put(member, list);
        }

        List getProperties(Member member) {
            return (List)this.map.get(member);
        }
    }
}

