/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.tags;

import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.navi.ClickableExtension;
import com.tonbeller.jpivot.olap.navi.ClickableExtensionImpl;
import com.tonbeller.jpivot.table.ClickableMember;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import com.tonbeller.wcf.controller.RequestContext;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.log4j.Logger;

public abstract class OlapModelTag
extends BodyTagSupport {
    private static Logger logger = Logger.getLogger((Class)OlapModelTag.class);
    private List clickables;
    private String queryName;
    private boolean stackMode = true;

    public void release() {
        super.release();
        this.stackMode = true;
    }

    public void addClickable(ClickableMember clickable) {
        this.clickables.add(clickable);
    }

    public int doStartTag() throws JspException {
        this.clickables = new ArrayList();
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            logger.info((Object)"enter");
            RequestContext context = RequestContext.instance();
            OlapModel om = this.getOlapModel(context);
            om = (OlapModel)om.getTopDecorator();
            om.setLocale(context.getLocale());
            om.setID(this.id);
            HttpSession session = this.pageContext.getSession();
            om.setServletContext(session.getServletContext());
            ClickableExtension ext = (ClickableExtension)om.getExtension("clickable");
            if (ext == null) {
                ext = new ClickableExtensionImpl();
                om.addExtension(ext);
            }
            ext.setClickables(this.clickables);
            OlapModelProxy omp = OlapModelProxy.instance(this.id, session, this.stackMode);
            if (this.queryName != null) {
                omp.initializeAndShow(this.queryName, om);
            } else {
                omp.initializeAndShow(om);
            }
            return 6;
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }

    protected abstract OlapModel getOlapModel(RequestContext var1) throws Exception;

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setStackMode(boolean stackMode) {
        this.stackMode = stackMode;
    }
}

