/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.util;

import com.tonbeller.jpivot.util.TreeNodeCallback;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreeNode {
    private TreeNode parent = null;
    private List children = null;
    private Object reference;

    public TreeNode(Object obj) {
        this.reference = obj;
        this.children = new ArrayList();
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    private void removeChild(TreeNode child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
        }
    }

    public void addChildNode(TreeNode child) {
        child.parent = this;
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public TreeNode deepCopy() {
        TreeNode newNode = new TreeNode(this.reference);
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            TreeNode child = (TreeNode)iter.next();
            newNode.addChildNode(child.deepCopy());
        }
        return newNode;
    }

    public TreeNode deepCopyPrune(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Depth is negative");
        }
        TreeNode newNode = new TreeNode(this.reference);
        if (depth == 0) {
            return newNode;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            TreeNode child = (TreeNode)iter.next();
            newNode.addChildNode(child.deepCopyPrune(depth - 1));
        }
        return newNode;
    }

    public int getLevel() {
        int level = 0;
        TreeNode p = this.parent;
        while (p != null) {
            ++level;
            p = p.parent;
        }
        return level;
    }

    public int walkTree(TreeNodeCallback callbackHandler) {
        int code = 0;
        code = callbackHandler.handleTreeNode(this);
        if (code != 0) {
            return code;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            TreeNode child = (TreeNode)iter.next();
            code = child.walkTree(callbackHandler);
            if (code < 2) continue;
            return code;
        }
        return code;
    }

    public int walkChildren(TreeNodeCallback callbackHandler) {
        int code = 0;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            TreeNode child = (TreeNode)iter.next();
            code = callbackHandler.handleTreeNode(child);
            if (code >= 2) {
                return code;
            }
            if (code != 0 || (code = child.walkChildren(callbackHandler)) <= 2) continue;
            return code;
        }
        return code;
    }

    public List getChildren() {
        return this.children;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object object) {
        this.reference = object;
    }
}

