/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class SqlTime
extends SqlData
implements DbmsConst {
    private String value = null;
    private String timezone = null;
    private short dbms_type = (short)8;
    private static Date now = new Date();

    public SqlTime(short s) throws SqlEx {
        super(true);
        switch (s) {
            case 6: 
            case 7: 
            case 8: {
                this.dbms_type = s;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC401B_INVALID_DATE);
            }
        }
    }

    public void set(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            if (this.dbms_type == 7) {
                if (string.length() < "HH:mm:ss".length() + "+HH:mm".length()) {
                    throw SqlEx.get(ERR_GC401B_INVALID_DATE);
                }
                int n = string.length() - "+HH:mm".length();
                this.timezone = string.substring(n);
                string = string.substring(0, n);
            }
            if (string.length() > "HH:mm:ss".length()) {
                string = string.substring(0, "HH:mm:ss".length());
            }
            this.setNotNull();
            this.value = string;
        }
    }

    public void set(SqlTime sqlTime) {
        this.dbms_type = sqlTime.dbms_type;
        if (sqlTime == null || sqlTime.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlTime.value;
            this.timezone = sqlTime.timezone;
        }
    }

    public String get() {
        return this.dbms_type == 7 ? this.value + this.timezone : this.value;
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            Time time;
            try {
                time = Time.valueOf(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setTime(time, null);
        }
    }

    public void setTime(Time time, TimeZone timeZone) throws SqlEx {
        this.set(time, timeZone);
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        this.set(timestamp, timeZone);
    }

    private void set(Date date, TimeZone timeZone) throws SqlEx {
        if (date == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        switch (this.dbms_type) {
            case 8: {
                this.value = SqlDates.formatTime(date, true);
                break;
            }
            case 6: {
                this.value = timeZone != null ? SqlDates.formatTime(date, timeZone) : SqlDates.formatTime(date, false);
                break;
            }
            case 7: {
                this.value = timeZone != null ? SqlDates.formatTime(date, timeZone) : SqlDates.formatTime(date, false);
                long l = System.currentTimeMillis();
                String string = this.timezone = timeZone != null ? SqlDates.formatTZ(timeZone, l) : SqlDates.formatTZ(l);
            }
        }
        if (this.value == null || this.value.length() != 8 || this.value.charAt(2) != ':' || this.value.charAt(5) != ':') {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    public String getString() throws SqlEx {
        return SqlDates.formatTime((Date)this.get(null), false);
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        return this.get(timeZone);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        return new Timestamp(this.get(timeZone).getTime());
    }

    public Object getObject() throws SqlEx {
        return this.get(null);
    }

    private Time get(TimeZone timeZone) throws SqlEx {
        Time time = null;
        switch (this.dbms_type) {
            case 8: {
                if (timeZone == null) {
                    timeZone = TimeZone.getDefault();
                }
                now.setTime(System.currentTimeMillis());
                if (!timeZone.useDaylightTime() || !timeZone.inDaylightTime(now)) {
                    time = SqlDates.parseTime(this.value, true);
                } else {
                    int n = timeZone.getDSTSavings() / 60000;
                    time = SqlDates.parseTime(this.value, SqlDates.getTZ(-n));
                }
                long l = time.getTime();
                long l2 = 86400000L;
                if (l < 0L || l >= l2) break;
                if (l + (long)timeZone.getRawOffset() < 0L) {
                    time.setTime(l + l2);
                    break;
                }
                if (l + (long)timeZone.getRawOffset() < l2) break;
                time.setTime(l - l2);
                break;
            }
            case 6: {
                time = timeZone != null ? SqlDates.parseTime(this.value, timeZone) : SqlDates.parseTime(this.value, false);
                break;
            }
            case 7: {
                if (timeZone == null) {
                    timeZone = TimeZone.getDefault();
                }
                now.setTime(System.currentTimeMillis());
                if (!timeZone.useDaylightTime() || !timeZone.inDaylightTime(now)) {
                    time = SqlDates.parseTime(this.value, SqlDates.getTZ(this.timezone));
                    break;
                }
                int n = timeZone.getDSTSavings();
                timeZone = SqlDates.getTZ(this.timezone);
                time = SqlDates.parseTime(this.value, SqlDates.getTZ((timeZone.getRawOffset() - n) / 60000));
            }
        }
        return time;
    }
}

