package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.service.RoleManagerService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.PaginatedOperationResult;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PaginationHelper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Set;

/**
 */
public class RoleManagerServiceImpl extends HibernateDaoImpl implements RoleManagerService {

    protected static final Log log = LogFactory.getLog(RoleManagerServiceImpl.class);

    private AbstractPlatformTransactionManager transactionManager;
    private UserAuthorityService userService;
    private ResourceFactory objectFactory;
    private ResourceFactory persistentClassFactory;

    public void setTransactionManager(AbstractPlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public ResourceFactory getObjectMappingFactory() {
        return objectFactory;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ResourceFactory getPersistentClassFactory() {
        return persistentClassFactory;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }
    
    public PaginatedOperationResult getUsersWithoutRole(final ExecutionContext context, final String roleName, final String userName,
                                    Set assignedUserNameSet, Set unassignedUserNameSet,
                                    int firstResult, int maxResults) {

        PaginatedOperationResult result;
        
        TransactionStatus transaction = null;

        try {

            // start transaction
            transaction = transactionManager.getTransaction(
                    new DefaultTransactionDefinition(
                            TransactionDefinition.PROPAGATION_REQUIRES_NEW));

            userService.assignUsers(context, roleName, assignedUserNameSet);
            userService.unassignUsers(context, roleName, unassignedUserNameSet);

            getHibernateTemplate().flush();

            result = PaginationHelper.paginatedGetOperationResult(firstResult, maxResults, new PaginationHelper.JasperService() {
                public List getResultList(int firstResult, int maxResults) {
                    return userService.getUsersWithoutRole(context, roleName, userName, firstResult, maxResults);
                }

                public int getResultCount() {
                    return userService.getUsersCountWithoutRole(context, roleName, userName);
                }
            });

        } finally {
            if (transaction != null && !transaction.isCompleted()) {
                try {
                    // rollback
                    transactionManager.rollback(transaction);
                } catch (Exception e) {
                    // suppress exception
                }
            }
        }


        return result;
    }

    public PaginatedOperationResult getUsersWithRole(final ExecutionContext context, final String roleName, final String userName,
                                 Set assignedUserNameSet, Set unassignedUserNameSet,
                                 int firstResult, int maxResults) {

        PaginatedOperationResult result;

        TransactionStatus transaction = null;
        try {

            // start transaction
            transaction = transactionManager.getTransaction(
                    new DefaultTransactionDefinition(
                            TransactionDefinition.PROPAGATION_REQUIRES_NEW));

            userService.assignUsers(context, roleName, assignedUserNameSet);
            userService.unassignUsers(context, roleName, unassignedUserNameSet);

            getHibernateTemplate().flush();

            result = PaginationHelper.paginatedGetOperationResult(firstResult, maxResults, new PaginationHelper.JasperService() {
                public List getResultList(int firstResult, int maxResults) {
                    return userService.getUsersWithRole(context, roleName, userName, firstResult, maxResults);
                }

                public int getResultCount() {
                    return userService.getUsersCountWithRole(context, roleName, userName);
                }
            });

        } finally {
            if (transaction != null && !transaction.isCompleted()) {
                try {
                    // rollback
                    transactionManager.rollback(transaction);
                } catch (Exception e) {
                    // suppress exception
                }
            }
        }

        return result;
    }

    public void updateRole(ExecutionContext context, String roleName, Role roleDetails,
                                 Set assignedUserNameSet, Set unassignedUserNameSet) {

        TransactionStatus transaction = null;
        try {

            // start transaction
            transaction = transactionManager.getTransaction(
                    new DefaultTransactionDefinition(
                            TransactionDefinition.PROPAGATION_REQUIRES_NEW));

            userService.assignUsers(context, roleName, assignedUserNameSet);
            userService.unassignUsers(context, roleName, unassignedUserNameSet);

            userService.updateRole(null, roleName, roleDetails);

            // commit
            transactionManager.commit(transaction);
            
        } finally {
            if (transaction != null && !transaction.isCompleted()) {
                try {
                    // rollback
                    transactionManager.rollback(transaction);
                } catch (Exception e) {
                    // suppress exception
                }
            }
        }
    }

}
