/* 
* Copyright (C) 2005 - 2007 JasperSoft Corporation. All rights reserved.
* http://www.jaspersoft.com.
* Licensed under commercial JasperSoft Subscription License Agreement
*/
package com.jaspersoft.jasperserver.export.modules.mt;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

import java.util.Iterator;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: TenantImporter.java 16193 2009-03-11 08:18:19Z andy21ca $
 */
public class TenantImporter extends BaseImporterModule
{
	private static final Log log = LogFactory.getLog(TenantImporter.class);
	
	private TenantModuleConfiguration moduleConfiguration;

    public void process()
	{
		for (Iterator it = indexElement.elementIterator(moduleConfiguration.getTenantIndexElement());
				it.hasNext(); ) {
			Element tenantElement = (Element) it.next();
			String tenantId = tenantElement.getText();
            process(tenantId);
		}
	}

	protected void process(String tenantId)
	{
		Tenant existingTenant = getTenantService().getTenant(executionContext, tenantId);
		if (existingTenant != null)
		{
			commandOut.info("Tenant " + tenantId + " already exists, skipping");
		}
		else
		{
			if (log.isDebugEnabled())
			{
				log.debug("Deserializing tenant " + tenantId);
			}
			
			Tenant tenant = (Tenant) deserialize(getModuleConfiguration().getTenantsDirectory(),
					getTenantFileName(tenantId), 
					getModuleConfiguration().getTenantSerializer());
			getTenantService().putTenant(executionContext, tenant);
			
			commandOut.info("Imported tenant " + tenantId);
		}
	}

	protected String getTenantFileName(String tenantId)
	{
		return tenantId + ".xml";
	}

	protected TenantService getTenantService()
	{
		return getModuleConfiguration().getTenantService();
	}

	public TenantModuleConfiguration getModuleConfiguration()
	{
		return moduleConfiguration;
	}

	public void setModuleConfiguration(TenantModuleConfiguration moduleConfiguration)
	{
		this.moduleConfiguration = moduleConfiguration;
	}

}
