/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.export.modules.repository;

import com.jaspersoft.jasperserver.api.JSException;
import java.io.InputStream;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.lob.SerializableBlob;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: OlapUnitViewOptionsDataProvider.java 14754 2008-12-06 22:51:31Z swood $
 * This should not be used any more
 */
public class OlapUnitViewOptionsDataProvider implements ResourceDataProvider {
	
	private static final Log log = LogFactory.getLog(OlapUnitViewOptionsDataProvider.class);

	private String filenameSuffix;

	public String getFileName(Resource resource) {
		return resource.getName() + getFilenameSuffix();
	}

	public InputStream getData(ExporterModuleContext exportContext, Resource resource) {

		OlapUnit unit = (OlapUnit) resource;
		InputStream dataStream;
		Object viewOptions = unit.getOlapViewOptions();
		if (viewOptions == null) {
			dataStream = null;
		} else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(baos));
            e.writeObject(unit.getOlapViewOptions());
            e.flush();
            e.close();
			dataStream = new BufferedInputStream(new ByteArrayInputStream(baos.toByteArray()));
		}
		return dataStream;
	}

	public String getFilenameSuffix() {
		return filenameSuffix;
	}

	public void setFilenameSuffix(String filenameSuffix) {
		this.filenameSuffix = filenameSuffix;
	}

}
