/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import javax.naming.NamingException;

import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;

/**
 * @author swood
 *
 */
public class ObjectPermissionTest extends AbstractDependencyInjectionSpringContextTests {

	Properties jdbcProps;

	HibernateRepositoryService repositoryService;
	UserAuthorityService userAuthorityService;
	ObjectPermissionService objectPermissionService;

	boolean error = false;

	public HibernateRepositoryService getRepositoryService() {
		return repositoryService;
	}

	public void setRepositoryService(HibernateRepositoryService repositoryService) {
		this.repositoryService = repositoryService;
	}

	public ObjectPermissionService getObjectPermissionService() {
		return objectPermissionService;
	}

	public void setObjectPermissionService(
			ObjectPermissionService objectPermissionService) {
		this.objectPermissionService = objectPermissionService;
	}

	public UserAuthorityService getUserAuthorityService() {
		return userAuthorityService;
	}

	public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
		this.userAuthorityService = userAuthorityService;
	}

	public ObjectPermissionTest(String name) {
		super(name);
		setAutowireMode(AUTOWIRE_BY_NAME);
	}
	
    protected Properties loadJdbcProps() throws IOException, FileNotFoundException, NamingException {
        jdbcProps = new Properties();
        String jdbcPropFile = System.getProperty("test.hibernate.jdbc.properties");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(jdbcPropFile));
        jdbcProps.load(is);
        is.close();
        return jdbcProps;
    }

    protected String[] getConfigLocations() {
		try {
			loadJdbcProps();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		// metadata.additionalSettings=hibernateRepositoryAdditionalSettings.xml

		if (jdbcProps.getProperty("metadata.additionalSettings") == null) {
			return
					new String[] {"hibernateConfig.xml", "userAuthorityService.xml", "viewService.xml"};
		} else {
			return
					new String[] {"hibernateConfig.xml", jdbcProps.getProperty("metadata.additionalSettings"), "userAuthorityService.xml", "viewService.xml"};
		}
    }

	// Now let's do some object identity outside of security

	public void testObjectPermissionMaintenance() throws Exception {
		System.out.println("testObjectPermissionMaintenance");
		try {

			Folder root = repositoryService.getFolder(null, Folder.SEPARATOR);

			// Set read and admin permissions on the root folder. Since it is the parent of everything,
			// these are the default permissions

			Role userRole = userAuthorityService.getRole(null, ObjectPermissionServiceTest.userRoleName);
			Role adminRole = userAuthorityService.getRole(null, ObjectPermissionServiceTest.administratorRoleName);
			createObjectPermission(root, adminRole, SimpleAclEntry.ADMINISTRATION);
		} catch (Exception e) {
			error = true;
			throw e;
		}
	}

	private ObjectPermission createObjectPermission(InternalURI target, Role role, int permissionMask) {
		ObjectPermission permission = objectPermissionService.newObjectPermission(null);
		permission.setURI(target.getURI());
		permission.setPermissionRecipient(role);
		permission.setPermissionMask(permissionMask);
		objectPermissionService.putObjectPermission(null, permission);
		return permission;
	}
}
