/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.datasource.test;

import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;

/**
 * @author swood
 *
 */
public class CustomDataSourceServiceFactory {

	public ReportDataSourceService plainDataSource() {
		return new CustomDataSourceService(new CustomDataSource());
	}
	public ReportDataSourceService tableModelDataSource() {
		return new CustomDataSourceService(new JRTableModelDataSource(new CustomTableModel()));
	}
	public ReportDataSourceService beanArrayDataSource() {
		return new CustomDataSourceService(new JRBeanArrayDataSource(CustomBeanFactory.getBeanArray()));
	}
	public ReportDataSourceService beanCollectionDataSource() {
		return new CustomDataSourceService(new JRBeanCollectionDataSource(CustomBeanFactory.getBeanCollection()));
	}
	
	
}
