package com.jaspersoft.jasperserver.war.action;

import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.RequestContext;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;

import java.util.*;

import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.war.common.URIUtil;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;

/**
 *  @author schubar
 *
 */

public class BaseManagerAction extends FormAction {

    public static final String UM_CURRENT_USER = "currentUser";
    public static final String UM_CURRENT_USER_ROLES = "currentUserRoles";
    public static final String SUPERUSER_ROLE = "superuserRole";
    public static final String ADMIN_ROLE = "adminRole";

    public static final String ROLE_SUPERUSER = "ROLE_SUPERUSER";
    public static final String ROLE_ADMINISTRATOR = "ROLE_ADMINISTRATOR";

    private TenantService tenantService;

    protected ConfigurationBean configuration;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setConfiguration(ConfigurationBean configurationBean) {
        this.configuration = configurationBean;
    }

    public TenantService getTenantService() {
        return tenantService;
    }

    public Map getSession(RequestContext context) {
        return context.getExternalContext().getSessionMap().asMap();
    }

    protected Set getTenantsCriteriaSet(String tenantId) {
        Set tenantIdSet = null;

        if (tenantId != null) {
            tenantIdSet = new HashSet();
            
            if (!tenantId.equals(TenantService.ORGANIZATIONS)) {
                tenantIdSet.add(tenantId);

                List allTenants = getTenantService().getAllSubTenantList(null, tenantId);

                if (allTenants != null) {
                    for (Iterator it = allTenants.iterator(); it.hasNext(); ) {
                        Tenant tenant = (Tenant) it.next();

                        tenantIdSet.add(tenant.getId());
                    }
                }
            }
        }

        return tenantIdSet;
    }

    public String getDecodedRequestParameter(RequestContext context, String name) {
        return URIUtil.uriDecode(context.getRequestParameters().get(name));
    }

    protected String getCurrentUser(RequestContext context) {

        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();

        String name = authenticationToken.getName();

        TenantQualified tenantQualified = (TenantQualified) authenticationToken.getPrincipal();
        if (authenticationToken.getPrincipal() instanceof TenantQualified) {

            String tenantId = tenantQualified.getTenantId();
            return (tenantId != null) ? name + configuration.getUserNameSeparator() + tenantId : name;
        }

        return name;
    }

    protected List getCurrentUserRoles(RequestContext context) {

        List rList = new ArrayList();

        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();

        if (authenticationToken.getPrincipal() instanceof MetadataUserDetails) {
            MetadataUserDetails userDetails = (MetadataUserDetails) authenticationToken.getPrincipal();

            Set roles = userDetails.getRoles();

            if (roles != null) {

                rList.addAll(roles);
            }
        }

        return rList;
    }
}
