/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.war.action;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.tags.PaginatorTag;

public class RepositoryAction extends FormAction {

	protected final Log log = LogFactory.getLog(this.getClass());

	protected static final Class[] RESOURCE_TYPES = {ReportUnit.class, OlapUnit.class, ContentResource.class};
	
//	protected void initBinder(RequestContext context, DataBinder binder) {
//		binder.registerCustomEditor(byte[].class,
//				new ByteArrayMultipartFileEditor());
//	}

	private RepositoryService repository;
	private String flowAttributeFolder;
	private MessageSource messages;//FIXME not used
	private ConfigurationBean configuration;

	/*
		 * method to get the reposervice object arguments: none returns:
		 * RepositoryService
		 */
	public RepositoryService getRepository() {
		return repository;
	}

	/*
	 * method to set the reposervice object arguments: RepositoryService
	 * returns: void
	 */
	public void setRepository(RepositoryService repository) {
		this.repository = repository;
	}

	public MessageSource getMessages()
	{
		return messages;
	}

	public void setMessages(MessageSource messages)
	{
		this.messages = messages;
	}

	public ConfigurationBean getConfiguration()
	{
		return configuration;
	}

	public void setConfiguration(ConfigurationBean configuration)
	{
		this.configuration = configuration;
	}

	public RepositoryAction()
	{
//		setFormObjectClass(CreateReportWizardDTO.class); 
//		// custom form backing object class							
//		setFormObjectName(FORM_OBJECT_KEY);
//		setFormObjectScope(ScopeType.FLOW); // this is a multi-page wizard!
//		setValidator(new CreateReportFlowValidator());
	}

	public Event initAction(RequestContext context)
	{
		String folderURI = context.getRequestParameters().get("folder");

		if (folderURI == null)
		{
			folderURI = context.getFlowScope().getString(getFlowAttributeFolder());
			if (folderURI == null)
			{
				folderURI = "/";
			}
		}
		else
		{
			context.getFlowScope().put(getFlowAttributeFolder(), folderURI);
		}

		List pathFolders = getPathFolders(folderURI);
		context.getRequestScope().put("pathFolders", pathFolders);

		ExecutionContext executionContext = JasperServerUtil.getExecutionContext(context);

		List folders = repository.getSubFolders(executionContext, folderURI);

		Class[] resourceTypes = getResourceTypes();
		FilterCriteria[] criterias = new FilterCriteria[resourceTypes.length];
		for (int i = 0; i < resourceTypes.length; i++)
		{
			FilterCriteria criteria = FilterCriteria.createFilter(resourceTypes[i]);
			criteria.addFilterElement(FilterCriteria.createParentFolderFilter(folderURI));
			criterias[i] = criteria;
		}

		List resourceLookups = repository.loadResourcesList(executionContext, criterias);
		
		List resources = new ArrayList();
		resources.addAll(folders);
		resources.addAll(resourceLookups);

		context.getRequestScope().put("resources", resources);

		return success();
	}
	
	protected Class[] getResourceTypes()
	{
		return RESOURCE_TYPES;
	}

	public Event goToPage(RequestContext context)
	{
		context.getFlowScope().put(
			PaginatorTag.CURRENT_PAGE_REQUEST_PARAMETER, 
			context.getRequestParameters().get(PaginatorTag.CURRENT_PAGE_REQUEST_PARAMETER)
			);

		return success();
	}

	protected List getPathFolders(String uri)
	{
		List pathFolders = new ArrayList();

		Folder parentFolder = null;

		StringTokenizer tkzer = new StringTokenizer(uri, Folder.SEPARATOR, false);
		while(tkzer.hasMoreTokens())
		{
			String token = tkzer.nextToken();

			Folder folder = new FolderImpl();
			folder.setName(token);
			folder.setParentFolder(parentFolder);

			pathFolders.add(folder);

			parentFolder = folder;
		}

		return pathFolders;
	}

	public String getFlowAttributeFolder() {
		return flowAttributeFolder;
	}

	public void setFlowAttributeFolder(String flowAttributeFolder) {
		this.flowAttributeFolder = flowAttributeFolder;
	}
}
