/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.war.common;

import org.apache.commons.httpclient.methods.PostMethod;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: HibernateLoggingService.java 8408 2007-05-29 23:29:12Z melih $
 */
public class HeartbeatDatabaseInfo extends HeartbeatInfo
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String databaseName = null;
	private String databaseVersion = null;

	/**
	 * @return Returns the databaseName.
	 */
	public String getDatabaseName() {
		return databaseName;
	}

	/**
	 * @param databaseName The databaseName to set.
	 */
	public void setDatabaseName(String databaseName) {
		this.databaseName = databaseName;
	}

	/**
	 * @return Returns the databaseVersion.
	 */
	public String getDatabaseVersion() {
		return databaseVersion;
	}

	/**
	 * @param databaseVersion The databaseVersion to set.
	 */
	public void setDatabaseVersion(String databaseVersion) {
		this.databaseVersion = databaseVersion;
	}

	public void contributeToHttpCall(PostMethod post)
	{
		post.addParameter("repoDbName[]", getDatabaseName() == null ? "" : getDatabaseName());
		post.addParameter("repoDbVersion[]", getDatabaseVersion() == null ? "" : getDatabaseVersion());
		post.addParameter("repoDbCount[]", String.valueOf(getCount()));
	}

	public String getKey()
	{
		return 
			getDatabaseName() 
			+ "|" + getDatabaseName();
	}

}
