package com.jaspersoft.jasperserver.war.common;

import java.io.Serializable;
import java.util.Set;
import java.util.HashSet;

/**
 */
public class UsersOperationResult implements Serializable {

    private String roleName;

    private Set assignedUsers;

    private Set unassignedUsers;

    public UsersOperationResult(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Set getAssignedUsers() {

        if (assignedUsers == null) {
            assignedUsers = new HashSet();
        }

        return assignedUsers;
    }

    public void setAssignedUsers(Set assignedUsers) {
        this.assignedUsers = assignedUsers;
    }

    public Set getUnassignedUsers() {

        if (unassignedUsers == null) {
            unassignedUsers = new HashSet();
        }

        return unassignedUsers;
    }

    public void setUnassignedUsers(Set unassignedUsers) {
        this.unassignedUsers = unassignedUsers;
    }

    public Object clone() throws CloneNotSupportedException {
        UsersOperationResult clone = new UsersOperationResult(this.roleName);

        clone.getAssignedUsers().addAll(this.getAssignedUsers());
        clone.getUnassignedUsers().addAll(this.getUnassignedUsers());

        return clone;
    }
}

