var BaseUserAndRoleListModel = Class.create(PaginatedListBoxModel, {

    getNoItemsMessage : function () {
        return "No Items Found"
    },

    getItems : function () {

    },

    setItems : function (items) {

    },

    getItemAt : function (index) {

    },

    getIndexAt : function (item) {

    }
});

var UserListModel = Class.create(BaseUserAndRoleListModel, {

    initialize: function($super, users, firstResult, maxResult, totalResult, tenantPathMap) {

        $super(users, firstResult, maxResult, totalResult);

        this.users = users;
        this.tenantPathMap = tenantPathMap;
    },

    getUsers: function() {

        return this.users;
    },

    getOptionsCount: function() {

        return this.users.length;
    },

    getValueAt : function (index) {

        var un = this.users[index].userName;
        var t = this.users[index].tenantId;

        return UserUtil.getUserNameWithTenant(un, t);
    },

    getValueHtmlAt : function (index) {

        var user = this.users[index];

        if (UserUtil.isFakeUser(user)) {

            return this.getNoItemsMessage();
        } else {

            return UserUtil.getUserNameWithoutTenant(user.userName);
        }
    },

    getClassNameAt : function (index) {
        var user = this.users[index];

        if (UserUtil.isFakeUser(user)) {

            return 'listItemDisabled listItem notSelectable noResultsFound';
        } else {

            return (user.enabled) ? 'list_default listItem' : 'listItemDisabled listItem';
        }
    },

    getTooltipAt : function (index) {
        if (UserUtil.isFakeUser(this.users[index])) {

            return null;
        } else {

            var fullName = this.users[index].fullName;

            var tenantId = this.users[index].tenantId;
            var tenantPath = (tenantId) ? this.tenantPathMap[tenantId] : '';

            return UserListModel.getTooltipHtml(fullName, tenantPath);
        }
    },

    containsValue : function ($super, user) {
        return $super(user.userName);
    },

    getItems : function () {

        return this.users;
    },

    setItems : function (items) {
        this.users = items;
    },

    getItemAt : function (index) {

        return this.users[index];
    },

    getIndexAt : function (item) {

        var index = -1;

        var i = 0;
        this.users.each(function (user) {

            if (item.userName == user.userName) {

                index = i;
                throw $break;
            }
            i ++;
        });

        return index;
    }
});

UserListModel.getTooltipHtml = function(fullName, tenantName) {

    var fn = '<p class="label">' + UserListModel.FULL_NAME + '</p>' +
             '<p style="margin-bottom:0">' + ((fullName) ? fullName : '&nbsp;') + '</p>';

    var tn = '<p class="label">' + UserListModel.TENANT_NAME + '</p>' +
             '<p>' + ((tenantName) ? tenantName : '&nbsp;') + '</p>';

    return (fn + tn);
}

UserListModel.FULL_NAME = "Full Name";
UserListModel.TENANT_NAME = "Organization";

var RoleListModel = Class.create(BaseUserAndRoleListModel, {

    initialize: function($super, roles, firstResult, maxResult, totalResult, tenantPathMap) {

        $super(roles, firstResult, maxResult, totalResult);

        this.roles = roles;
        this.tenantPathMap = tenantPathMap;
    },

    getItems: function() {

        return this.roles;
    },

    getOptionsCount: function() {

        return this.roles.length;
    },

    getValueAt : function (index) {

        var rn = this.roles[index].roleName;
        var t = this.roles[index].tenantId;

        return RoleUtil.getRoleNameWithTenant(rn, t);
    },

    getValueHtmlAt : function (index) {

        var role = this.roles[index];

        if (RoleUtil.isFakeRole(role)) {

            return this.getNoItemsMessage();
        } else {

            return RoleUtil.getRoleNameWithoutTenant(role.roleName);
        }
    },

    getClassNameAt : function (index) {

        var role = this.roles[index];

        if (RoleUtil.isFakeRole(role)) {

            return 'listItemDisabled listItem notSelectable noResultsFound';
        } else {

            return 'list_default listItem';
        }
    },

    getTooltipAt : function (index) {

        if (RoleUtil.isFakeRole(this.roles[index])) {

            return null;
        } else {

            var tenantId = this.roles[index].tenantId;

            return '<p class="label">' + RoleListModel.TENANT_NAME + '</p>' +
                   '<p>' + ((tenantId) ? this.tenantPathMap[tenantId] : '&nbsp;') + '</p>';
        }
    },

    containsValue : function ($super, role) {
        return $super(role.roleName);
    },

    getItems : function () {

        return this.roles;
    },

    setItems : function (items) {
        this.users = items;
    },

    getItemAt : function (index) {

        return this.roles[index];
    },

    getIndexAt : function (item) {

        var index = -1;

        var i = 0;
        this.roles.each(function (role) {

            if (item.roleName == role.roleName) {

                index = i;
                throw $break;
            }
            i ++;
        });

        return index;
    }

});
RoleListModel.TENANT_NAME = "Organization";


//var RolesListModel = Class.create(ListBoxModel, {
//
//    initialize: function(roles) {
//
//        this.roles = roles;
//    },
//
//    getOptionsCount: function() {
//
//        return this.roles.length;
//    },
//
//    getValueAt : function (index) {
//
//        return this.roles[index].roleName;
//    },
//
//    getValueHtmlAt : function (index) {
//
//        return this.roles[index].roleName;
//    },
//
//    getClassNameAt : function (index) {
//
//        return 'list_default listItem';
//    },
//
//    containsRole : function (roleName) {
//
//        var contain = false;
//
//        this.roles.each(function (role) {
//            if (role.roleName == roleName) {
//                contain = true;
//            }
//        });
//
//        return contain;
//    }
//});

//var AvailableRolesListModel = Class.create(PaginatedListBoxModel, {
//
//    initialize: function(roles, firstResult, maxResult, totalResult) {
//
//        this.roles = roles;
//        this.firstResult = firstResult;
//        this.maxResult = maxResult;
//        this.totalResult = totalResult;
//    },
//
//    getOptionsCount: function() {
//
//        return this.roles.length;
//    },
//
//    getValueAt : function (index) {
//
//        return this.roles[index].roleName;
//    },
//
//    getValueHtmlAt : function (index) {
//
//        var role = this.roles[index];
//
//        return (RoleUtil.isFakeRole(role))
//                ? AvailableRolesListModel.MESSAGE_SOURCE.getMessage('noRolesFound')
//                : role.roleName;
//    },
//
//    getClassNameAt : function (index) {
//
//        var role = this.roles[index];
//
//        return (RoleUtil.isFakeRole(role))
//                ? 'listItemDisabled listItem notSelectable noResultsFound'
//                : 'list_default listItem';
//    },
//
//    getFirstResult : function () {
//
//        return this.firstResult;
//    },
//
//    getMaxResult : function () {
//
//        return this.maxResult;
//    },
//
//    getTotalResult : function () {
//
//        return this.totalResult;
//    },
//
//    containsRole : function (roleName) {
//
//        var contain = false;
//
//        this.roles.each(function (role) {
//            if (role.roleName == roleName) {
//                contain = true;
//            }
//        });
//
//        return contain;
//    }
//});
//
//AvailableRolesListModel.MESSAGE_SOURCE = {};
