var MessageSource = Class.create({

    initialize : function (source) {

        this.source = source;
    },

    getMessage : function (id, replacementArray) {
        var msg = this.source[id];

        if (msg && replacementArray && replacementArray.length) {
            for (var i = 0; i < replacementArray.length; i++) {
                var pattern = new RegExp("\\{" + i + "\\}", "g");
                msg = msg.replace(pattern, replacementArray[i])
            }
        }

        return msg;
    }
});

var RegExpRepresenter = Class.create({

    initialize: function(expression) {

        this.charMap = {'\\s': ' '};

        this.expressionTokens = this.__parse(expression);
    },

    __parse : function(expression) {
        var result = $A();

        for (var i = 1; i < expression.length - 1; i++) {

            var ch = expression.charAt(i);

            if (ch == '\\') {

                ch += expression.charAt(++ i);
            }

            if (ch == '\\u') {

                ch += expression.substring(++i, i + 4);
                i += 3;
            }

            result.push(ch);
        }

        return result;
    },

    getCharacters : function () {
        var result = $A();

        this.expressionTokens.each(function(token) {

            if (token.startsWith('\\u')) {

                result.push(eval('"' + token + '"'));
            } else if (token.startsWith('\\')) {

                var char = this.charMap[token];
                result.push((char) ? char : token.substring(1, token.length));
            } else {

                result.push(token);
            }
        }.bind(this));

        return result;
    },

    getRepresentedString : function() {
        var result = "";

        var chars = this.getCharacters();

        var len = chars.length;
        for(var i = 0; i < len; i ++) {
            var char = chars[i];

            if (char == ' ' || char == '.' || char == ',') {
                result += '[' + char + ']';
            } else {
                result += char;
            }


            if (i < len - 1) {
                result += ', ';
            }
        }

        return result;
    }

});