var RoleManager = Class.create(BaseUserAndRoleManager, {
    initialize: function($super, messageSource, defaultRole) {

        var dataRetriever = this.createDataRetriever(messageSource);
        var dataUpdater = this.createDataUpdater();

        var viewer = new RoleViewer(messageSource, dataRetriever);
        var editor = this.createEditor(messageSource, dataRetriever, dataUpdater);
        var creator = this.createCreator(messageSource, dataRetriever);

        var defaultSearchName = UserUtil.getUserNameWithoutTenant(defaultRole);
        var defaultTenantId = UserUtil.getTenantWithoutUserName(defaultRole);

        $super(viewer, editor, creator, dataRetriever, dataUpdater, messageSource,
                defaultSearchName, defaultTenantId, defaultRole);

        this.tenantTree.onTenantsLoaded = function () {

            this.viewer.setTenantPathMap(this.tenantTree.getTenantPathMap());
            this.editor.setTenantPathMap(this.tenantTree.getTenantPathMap());
        }.bind(this);

        var regExpRepresenter = new RegExpRepresenter(BaseUserAndRoleManager.Configuration.roleNameNotSupportedSymbols);
        $('roleNameNotSupportedSymbols').innerHTML += regExpRepresenter.getRepresentedString();
    },

    createDataRetriever : function () {

        var dataRetriever =
                new RoleDataRetriever(BaseUserAndRoleManager.State.flowExecutionKey, this.getBaseErrorHandler());

        dataRetriever.onItemsRetrieved = function (data) {

            var model = new RoleListModel(data.roles, data.firstResult, data.maxResult, data.totalResult,
                    this.tenantTree.getTenantPathMap());

            model.getNoItemsMessage = function () {

                return this.messageSource.getMessage('noRolesFound');

            }.bind(this);

            this.itemList.setModel(model);

            this.selectPreviousItem();            

            new HoverBehavior('#items td.list_default', '#items td.listItemDisabled');
        }.bind(this);

        return dataRetriever;
    },

    createDataUpdater : function () {

        var dataUpdater =
                new RoleDataUpdater(BaseUserAndRoleManager.State.flowExecutionKey, this.getBaseErrorHandler());
        
        return dataUpdater;
    },

    createEditor : function (messageSource, dataRetriever, dataUpdater) {

        var editor = new RoleEditor(messageSource, dataRetriever, dataUpdater);

        editor.onsave = function (originalItem, newItem) {

            this.selectedItem = RoleUtil.getRoleNameWithTenant(newItem.roleName, newItem.tenantId);
            this.dataUpdater.updateItem(originalItem, newItem);
        }.bind(this);

        return editor;
    },

    createCreator : function (messageSource, dataRetriever) {

        var creator = new RoleCreator(messageSource, dataRetriever);;

        creator.onsubmit = function (role) {

            var rn = RoleUtil.getRoleNameWithTenant(role.roleName, role.tenantId);
            this.selectedItem = rn;
            this.dataUpdater.createItem(role);
        }.bind(this);

        return creator;
    },

    editItem : function($super, item) {

        this.editor.setSearchUserName(this.viewer.slb.getSearchWord());
        this.editor.setUsersModel(this.viewer.slb.getListModel());
        this.editor.setUsersCount(this.viewer.usersCount.innerHTML);

        $super(item);
    }

});

//var RoleManager = Class.create(Manager, {
//    initialize: function($super, messageSource) {
//
//        var dataRetriever = this.createDataRetriever();
//
//        $super(new RoleViewer(messageSource), new RoleEditor(this.messageSource), new RoleCreator(this.messageSource), dataRetriever, messageSource);
//    },
//
//    createDataRetriever : function () {
//
//        var dataRetriever = new RoleDataRetriever(Manager.State.flowExecutionKey);
//
//        dataRetriever.onItemsRetrieved = function (data) {
//
//            var model = new RoleListModel(data.roles, data.firstResult, data.maxResult, data.totalResult,
//                    this.tenantTree.getTenantPathMap());
//
//            this.itemList.setModel(model);
//
//        }.bind(this);
//
//        return dataRetriever;
//    }
//});