var RoleViewer = Class.create(ItemViewer, {
    initialize : function ($super, messageSource, dataRetriever) {

        $super('roleViewer', messageSource);

        this.defaultUserLinkId = 'roleUserLink';

        this.roleName = $('roleViewerRoleName');
        this.external = $('roleViewerRoleExternal');
        this.usersCount = $('roleViewerUsersCount');
        this.tenant = $('roleViewerTenant');

        this.dataRetriever = dataRetriever;
        this.tenantPathMap = {};

        this.slb = new SearchListBox('roleViewerUsers', null, messageSource.getMessage('defaultUserSearchText'));
        this.slb.setInputStyle('new_tabletextfieldorlist searchInput searchListBoxInput');
        this.slb.setListStyle('new_tabletextfieldorlist searchListBoxList');

        this.setUpUserList();
        this.setUpDataRetriever();
    },

    setUpUserList : function() {

        this.slb.loadItems = function (searchWord, firstResult) {

            if (this.item && this.item.roleName) {

                this.dataRetriever.getRoleUsers(this.item, searchWord, this.tenantId, firstResult);
            }
        }.bind(this);
    },

    usersDataRetrieved: function (data) {

        if (this.slb.getSearchWord().blank()) {
            this.usersCount.innerHTML = data.totalResult;
        }
        
        var model =
                new UserListModel(data.users, data.firstResult, data.maxResult, data.totalResult, this.tenantPathMap);

        model.getNoItemsMessage = function () {

            return this.messageSource.getMessage('noUsersFound');

        }.bind(this);

        model.getValueHtmlAt = function (index) {


            var user = model.users[index];

            if (UserUtil.isFakeUser(user)) {

                return model.getNoItemsMessage();
            } else {

                var a = document.createElement('a');
                a.id = this.defaultUserLinkId + index;
                a.href = '#null';
                a.innerHTML = UserUtil.getUserNameWithoutTenant(user.userName);

                var tempDiv = document.createElement('div');
                tempDiv.appendChild(a);

                return tempDiv.innerHTML;
            }
        }.bind(this);

        this.slb.setListModel(model);

        this._createUserLinks(model.users);

        new HoverBehavior('#roleViewerUsers td.list_default', '#roleViewerUsers td.listItemDisabled');
    },

    setUpDataRetriever : function() {

        this.dataRetriever.addUsersRetrievedListener(this);
    },
    _createUserLinks : function(users) {

        var i = -1;
        users.each(function (u) {

            i++;
            var aElements = $$('a#' + this.defaultUserLinkId + i);

            if (aElements.length > 0) {

                var link = new LinkButton(aElements[0].id, 'editorLink', 'editorLinkHover', 'editorLinkDisabled');

                var un = UserUtil.getUserNameWithTenant(u.userName, u.tenantId);
                link.onclick = function () {

                    document.location="flow.html?_flowId=userListFlow&curlnk=3&userName=" + encodeUriParameter(un);
                }
            }
        }.bind(this));
    },
    
    getConfirmDelete : function () {
        var role = this.item;

        var name = role.roleName;
        var confirmDelete = new ConfirmMsgBox(
                "roleViewerDeleteConfirmation",
                this.messageSource.getMessage('deleteRoleHeader'),
                this.messageSource.getMessage('deleteRoleMessage', ['<b>' + name + '</b>']),
                this.messageSource.getMessage('deleteRoleOk'),
                this.messageSource.getMessage('deleteRoleCancel'));

        return confirmDelete;
    },

    setItem : function(item) {
        this.item = item;

        this.slb.clearSearch();
        this.slb.loadItems("", 0);
        
        this.refresh();
    },

    refresh : function() {
        var role = this.item;

        if (role) {
            var roleName = RoleUtil.getRoleNameWithoutTenant(role.roleName);

            this.roleName.innerHTML = roleName;
            this.external.style.display = (role.external) ? 'block' : 'none';

            var disabled = false;
            if (!role.tenantId) {

                disabled = !BaseUserAndRoleManager.isCurrentUserSuperuser();
            } else {

                disabled = role.external && !BaseUserAndRoleManager.isCurrentUserSuperuser();
            }
            this.deleteItemBtn.setDisabled(disabled);
            this.editItemBtn.setDisabled(disabled);

            this.tenant.innerHTML = '';

            this._createTenantLink(role.tenantId);

            this.resize();
        } else {

            this.roleName.innerHTML = '';
            this.external.hide();
            this.tenant.innerHTML = '&nbsp;';
        }
    },

    _createTenantLink : function(tenantId) {
        
        var tp = (tenantId) ? this.tenantPathMap[tenantId] : tenantId;
        if (tp) {

            var link = this._createLink(this.tenant, tp);

            link.onclick = function () {

                document.location="flow.html?_flowId=tenantFlow&curlnk=3&tenantId=" + encodeUriParameter(tenantId);
            }
        } else {

            this.tenant.innerHTML = '&nbsp;';
        }
    },


//    _createTenantLinks : function() {
//
//        var viewerInstance = this;
//        var user = this.item;
//
//        this.roles.innerHTML = '';
//
//        var roles = user.roles;
//        if (roles) {
//
//            var i = 0;
//            roles.each(function (role) {
//
//                var link = viewerInstance._createLink(viewerInstance.roles, role.roleName);
//
//                if (i < roles.length - 1) {
//                    viewerInstance.roles.appendChild(document.createTextNode(", "));
//                }
//
//                i ++;
//            });
//        }
//    },

    isItemViewed : function(role) {
        return (this.item && this.item.roleName == role.roleName);
    },

    resize : function($super) {
        $super();

        var padding = isIE() ? 53 : 50;
        var h = ($(this.contentContainer.id).getHeight() - $('roleViewerRoleDetails').getHeight() - padding);
        $('roleViewerUsers').style.height = ((h > 0) ? h : 0) + 'px'; 

        this.slb.resize();
    }
});
