var TenantTreePro = Class.create({

    initialize: function(treeId, defaultTenantId) {

        this.treeId = treeId;
        this.tenantTreePanel = $(this.treeId);
        this.tenantTreeSupport = null;

        this.defaultTenantId = defaultTenantId;
        this.tenantPathMap = {};
        this.tenantPathSeparator = '.';

        if (!this.tenantTreePanel.treeSupport) {

            this.tenantTreeSupport = new TreeSupport(this.treeId, 'tenantTreeFoldersProvider', '/', this.ajaxErrorHandler, true);
            this.tenantTreePanel.treeSupport = this.tenantTreeSupport;

            this.tenantTreeSupport.treeFolderMouseUpHandler = function(inst) {
                return function(evt, node) {
                    inst.onTenantSelect(inst._getTenantId(node));
                };
            } (this);
        }

    },

    load : function () {

        this.tenantTreeSupport.showTree(this.treeId, 10, this.getOnLoadHandler(this), this.getOnLoadErrorHandler());
    },

    getTree : function () {
        return this.tenantTreeSupport.tree;
    },

    getSupport : function () {
        return this.tenantTreeSupport;
    },

    getTenantPathMap : function () {

        return this.tenantPathMap;
    },

    getSelectedTenant : function () {

        var node = this.getTree().getSelectedNode();

        return (node) ? this._getTenantId(node) : null;
    },

    selectTenant : function (tenantId) {

        if(!tenantId || tenantId.blank()) {

            return;
        }
        
        var tenantTreeInstanse = this;

        for (var id in nodes) {

            var node = nodes[id];
            if (node.param.id == tenantId) {

                this.tenantTreeSupport.openAndSelectNode(node.param.uri, function () {

                    tenantTreeInstanse.onTenantSelect(tenantId);
                });
            }
        }
    },

    _getTenantId : function (node) {

        if (node) {

            return node.param.id;
        } else {

            return null;
        }
    },

    getNodePath : function (node, tenantPathMap) {
        var tenantTreeInstanse = this;

        if (!tenantPathMap) {

            tenantPathMap == this.tenantPathMap;
        }

        var tenantId = this._getTenantId(node);
        var path = tenantPathMap[tenantId];

        if (!path) {

            var parentPath;
            if (node.parent) {

                var parentPath = this.getNodePath(node.parent, tenantPathMap);
                path = (parentPath) ? parentPath + this.tenantPathSeparator + node.name : node.name;
            } else {

                path = (node.param.id != 'organizations') ? node.name : "";
            }

            tenantPathMap[tenantId] = path;
        }

        return path;
    },

    getOnLoadHandler : function (tenantTreeInstanse) {

        return function () {

            // create map of tenants path
            var tenantPathMap = {};

            for (var id in nodes) {

                var node = nodes[id];
                var tenantId = tenantTreeInstanse._getTenantId(node);

                if (!tenantPathMap[tenantId]) {

                    tenantPathMap[tenantId] = tenantTreeInstanse.getNodePath(node, tenantPathMap);
                }
            }

            tenantTreeInstanse.tenantPathMap = tenantPathMap;

            tenantTreeInstanse.onTenantsLoaded();

            var rootNode = trees[tenantTreeInstanse.treeId].rootNode;
            if (tenantTreeInstanse.defaultTenantId && rootNode.param.id != tenantTreeInstanse.defaultTenantId) {

                tenantTreeInstanse.selectTenant(tenantTreeInstanse.defaultTenantId);
            } else {

                // select root node
                rootNode.select();

                tenantTreeInstanse.onTenantSelect(tenantTreeInstanse._getTenantId(rootNode));
            }

        };
    },

    getOnLoadErrorHandler : function (tenantTreeInstanse) {

        return function () { /* Do Nothing*/ };
    },


    onTenantSelect : function (tenantId) {
        /* Do Nothing*/
    },

    onTenantsLoaded : function () {
        /* Do Nothing*/
    },

    ajaxErrorHandler : function () {

    }

});

var TenantTreeOS = Class.create({

    load : function () {

        this.onTenantSelect(null);        
    },
    getTree : function () {
        return null;
    },

    getSupport : function () {
        return null;
    },

    getTenantPathMap : function () {

        return {};
    },

    getSelectedTenant : function () {

        return null/*'organizations'*/;
    },

    onTenantSelect : function (tenantId) {
        /* Do Nothing*/
    }

});
