var UserCreator = Class.create(ItemCreator, {

    initialize : function ($super, messageSource, dataRetriever) {

        $super('userCreator', messageSource);

        this.user = {};

        this.filteredUserName = new FilteredTextBox('userCreatorUserNameInput',
                    new RegExp(BaseUserAndRoleManager.Configuration.userNameNotSupportedSymbols, "g"));

        this.userName = this.filteredUserName.getElement();
        this.fullName = $('userCreatorFullNameInput');
        this.email = $('userCreatorEmailInput');
        this.password = $('userCreatorPasswordInput');
        this.confirmPassword = $('userCreatorConfirmPasswordInput');
        this.enabled = $('userCreatorUserEnabledInput');

        this.userNameValidator = null;
        this.emailValidator = null;
        this.passwordCompareValidator = null;
        this.validationSummary = null;

        this._setUpValidation(dataRetriever);

        this.refreshDialogState(this);
    },

    _setUpValidation : function (dataRetriever) {

        var creatorInstance = this;
        var rfcRegex = "^[^\\~\\`\\(\\)\\[\\]\\{\\}\\:\"\\;\'\/\\?\\<\\>\\+\\=\\\\|\\!\\@\\#\\$\\%\\^\\&\\*]+@([\\w+\\-]+\\.)+(\\w+)";

        this.userNameValidator = new ItemExistValidator(
                'userCreatorUserNameValidator',
                'userCreatorUserNameInput',
                'blur',
                this.messageSource.getMessage('userNameIsAlreadyInUse'),
                this.validationImg,
                dataRetriever);

        this.emailValidator = new RegularExpressionValidator(
                'userCreatorEmailValidator',
                new RegExp(rfcRegex),
                'userCreatorEmailInput',
                'blur',
                this.messageSource.getMessage('invalidEmail'),
                this.validationImg);

        this.passwordCompareValidator = new CompareValidator(
                'userCreatorConfirmPasswordValidator',
                CompareValidator.Operator.EQUALS,
                'userCreatorConfirmPasswordInput',
                'blur',
                'userCreatorPasswordInput',
                this.messageSource.getMessage('invalidConfirmPassword'),
                this.validationImg);

        this.password.observe('blur', function() {

            if (!creatorInstance.confirmPassword.value.blank()) {
                creatorInstance.passwordCompareValidator.evaluateIsValid();
            }
        });

        this.validationSummary = new ValidationSummary('userCreatorValidationSummary');
        this.validationSummary.registrValidator(this.userNameValidator);
        this.validationSummary.registrValidator(this.emailValidator);
        this.validationSummary.registrValidator(this.passwordCompareValidator);

        this.validationStack.addValidator(this.userNameValidator);
        this.validationStack.addValidator(this.emailValidator);
        this.validationStack.addValidator(this.passwordCompareValidator);
    },

    isRequiredFieldsEmpty : function () {
        return (this.userName.value.blank() || this.password.value.blank() ||this.confirmPassword.value.blank());
    },

    setTenantId : function ($super, tenantId) {

        $super(tenantId);
        this.userNameValidator.setTenantId(tenantId);
    },

    getItem : function () {

        var userName = this.userName.value;

//        var userName = UserUtil.getUserNameWithTenant(this.userName.value, this.tenantId);

        var user = {
            userName : userName,
            fullName : this.fullName.value,
            email : this.email.value,
            password : this.password.value,
            enabled : this.enabled.checked,
            roles : []
        };

        var defaultRole = BaseUserAndRoleManager.Configuration.userDefaultRole;
        if (defaultRole) {

            user.roles.push({roleName : defaultRole});
        }

        if (this.tenantId) {

            user.tenantId = this.tenantId;
        }

        return user;
    },

    show : function ($super) {
        this.submintClicked = false;
        
        this.userName.value = '';
        this.fullName.value = '';
        this.email.value = '';
        this.password.value = '';
        this.confirmPassword.value = '';
        this.enabled.checked = false,

        this.submitBtn.disabled = true;

        this.userNameValidator.setState(ControlValidator.State.UNKNOWN);
        this.emailValidator.setState(ControlValidator.State.UNKNOWN);
        this.passwordCompareValidator.setState(ControlValidator.State.UNKNOWN);

//        this.validationSummary.refresh();

        $super();
    }
});
