/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.ws.axis2;

import java.util.HashMap;
import java.util.Map;

import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;

/**
 * The default {@link ManagementServiceConfiguration} implementation.
 * 
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: DefaultManagementServiceConfiguration.java 14653 2008-11-17 12:43:37Z lucian $
 */
public class DefaultManagementServiceConfiguration implements
		ManagementServiceConfiguration {
	
	private Map exportParametersMap = new HashMap();

	/**
	 * Returns the map of export parameters beans indexed by output format.
	 * 
	 * @return the map of export parameters beans
	 */
	public Map getExportParametersMap() {
		return exportParametersMap;
	}

	/**
	 * Sets a map of export parameters beans indexed by output format.
	 * 
	 * @param exportParametersMap the export parameters beans map
	 * @see #getExportParameters(String)
	 */
	public void setExportParametersMap(Map exportParametersMap) {
		this.exportParametersMap = exportParametersMap;
	}

	/**
	 * Returns the export parameters object from the map
	 */
	public ExportParameters getExportParameters(String outputFormat) {
		return (ExportParameters) exportParametersMap.get(outputFormat);
	}

}
