/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.ws.axis2;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import java.io.IOException;
import javax.activation.DataSource;

/**
 * This class is used to transfer file usimg MTOM and SOAP with Attachments
 * @author gtoffoli
 */
public class ResourceDataSource implements DataSource{
    
    private FileResourceData fileResourceData = null;
    private String name = "";
    
    /** Creates a new instance of ResourceDataSource */
    public ResourceDataSource(String name, FileResourceData fileResourceData) {
        this.name = name;
        this.fileResourceData = fileResourceData;
    }

    public java.io.InputStream getInputStream() throws IOException {
        return fileResourceData.getDataStream();
    }

    public java.io.OutputStream getOutputStream() throws IOException {
        throw new java.io.IOException();
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public String getName() {
        return name;
         
    }

    public FileResourceData getFileResourceData() {
        return fileResourceData;
    }

    public void setFileResourceData(FileResourceData fileResourceData) {
        this.fileResourceData = fileResourceData;
    }
    
}
