/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.ws.axis2.scheduling;

import org.apache.axis.AxisFault;
import org.springframework.remoting.jaxrpc.ServletEndpointSupport;

import com.jaspersoft.jasperserver.ws.scheduling.Job;
import com.jaspersoft.jasperserver.ws.scheduling.JobSummary;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: ReportScheduler.java 9882 2007-09-03 11:53:45Z lucian $
 */
public class ReportScheduler extends ServletEndpointSupport {

	public static final String SERVICE_ACCESSOR_BEAN_NAME = "reportSchedulerServiceAccessor";
	
	public Job getJob(long id) throws AxisFault {
		return getService().getJob(id);
	}
	
	public Job scheduleJob(Job job) throws AxisFault {
		return getService().scheduleJob(job);
	}
	
	public Job updateJob(Job job) throws AxisFault {
		return getService().updateJob(job);
	}
	
	public void deleteJob(long id) throws AxisFault {
		getService().deleteJob(id);
	}
	
	public void deleteJobs(long[] ids) throws AxisFault {
		getService().deleteJobs(ids);
	}

	public JobSummary[] getAllJobs() throws AxisFault {
		return getService().getAllJobs();
	}
	
	public JobSummary[] getReportJobs(String reportURI) throws AxisFault {
		return getService().getReportJobs(reportURI);
	}
	
	protected ReportSchedulerService getService() {
		ReportSchedulerServiceAccessor accessor = (ReportSchedulerServiceAccessor) getApplicationContext().getBean(SERVICE_ACCESSOR_BEAN_NAME, ReportSchedulerServiceAccessor.class);
		return accessor.getSchedulerService();
	}

}
