/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.api.metadata.security;

import java.util.Collection;
import java.util.Iterator;

import org.acegisecurity.Authentication;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * A {@link BasicAclEntry} ACLs based method argument voter that works with
 * collections and arrays of objects. 
 * 
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: BasicMethodCollectionArgumentVoter.java 15217 2009-03-05 11:38:24Z lucian $
 */
public class BasicMethodCollectionArgumentVoter extends
		BasicMethodArgumentVoter {

	private static final Log log = LogFactory.getLog(BasicMethodCollectionArgumentVoter.class);
	
	@Override
	protected boolean accessPermitted(Authentication authentication,
			AclManager aclManager, Object secureObject) {
		boolean permitted = true;
		for (Iterator it = getObjectsIterator(secureObject); it.hasNext();) {
			Object object = (Object) it.next();
			if (!super.accessPermitted(authentication, aclManager, object)) {
				permitted = false;
				break;
			}
		}
		return permitted;
	}
	
	protected Iterator getObjectsIterator(Object secureObject) {
		Iterator<?> iterator;
		if (secureObject instanceof Collection) {
			iterator = ((Collection) secureObject).iterator();
		} else if (secureObject != null && secureObject.getClass().isArray()) {
			iterator = new ArrayIterator(secureObject);
		} else {
			iterator = new SingletonIterator(secureObject);
		}
		return iterator;
	}
	
}
