/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.irplugin;

import com.jaspersoft.jasperserver.irplugin.gui.RepositoryExplorer;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.flexdock.docking.DockingConstants;
import org.flexdock.view.View;

/**
 *
 * @author gtoffoli
 */
public class DockingUtil {
    
    public static View view = null;
    
    public static void installUI(RepositoryExplorer explorer)
    {
        if (view == null)
        {
            // Get the title from the branding properties...
            String title = "JasperServer";
            title = IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.title");
            String version = IRPlugin.getMainInstance().getBrandingProperties().getProperty("irplugin.version");
            
            java.text.MessageFormat mf = new java.text.MessageFormat(title, I18n.getCurrentLocale());
            title =  mf.format(new Object[]{version});
            
            view = createView("JasperServer",
                              title,
                              true, true, explorer);
            
            
        }
 
        boolean visible = false;
        if (!MainFrame.getMainInstance().getDesktopView().dock(view, DockingConstants.WEST_REGION, 0.3f))
        {
            visible = Misc.dockAt( view, DockingConstants.WEST_REGION, 0);
        }
        else
        {
            visible = true;
            org.flexdock.docking.DockingManager.setSplitProportion(view.getComponent(), 0.3f);
        }
        
        IRPlugin.getMainInstance().setViewVisible(visible );
    }
    
    /*
     *
     *
     */
    public static View createView(String id, String text, boolean closable, boolean pin, Component c) {
		
                View view = new View(id, text);
                
		if (closable)
                {
                    view.getTitlebar().addAction(DockingConstants.CLOSE_ACTION);
                    if ( view.getTitlebar().getActionButton(DockingConstants.CLOSE_ACTION) != null)
                    {
                        view.getTitlebar().getActionButton(DockingConstants.CLOSE_ACTION).addActionListener(
                        new ActionListener()
			{
				public void actionPerformed(ActionEvent e) 
				{
					View viewx = (View)javax.swing.SwingUtilities.getAncestorOfClass(View.class, (java.awt.Component)e.getSource());
			    		IRPlugin.getMainInstance().setViewVisible(false);
				}
			}
                    );
                    }
                }
		if (pin) view.addAction(DockingConstants.PIN_ACTION);

                
                 
		JPanel p = new JPanel();
		//		p.setBackground(Color.WHITE);
                p.setLayout(new BorderLayout());
		p.setBorder(new LineBorder(java.awt.Color.GRAY, 1));

		
		p.add(c, BorderLayout.CENTER);

		view.setContentPane(p);
		return view;
                
	}
    
}
