/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * @author swood
 *
 */
public class MetadataImplTestSuite extends TestSuite {

    static public void main(String[] args) {
    	junit.textui.TestRunner.run(suite());
    }
    
    /**
     * Creates a TestSuite to run all the tests in the right order. Methods with the
     * signature <code>public static Test suite()</code> are recognized
     * automatically by JUnit test-harnesses; see {@link TestSuite}.
     */
    public static Test suite() {

        TestSuite suite = new TestSuite();
        
        suite.addTestSuite(HibernateAccessTest.class);
        suite.addTestSuite(HibernateRepositoryTest.class);
		suite.addTestSuite(ContentRepositoryTest.class);		
        suite.addTestSuite(UserAuthorityServiceTest.class);
		suite.addTestSuite(ObjectPermissionTest.class);
        suite.addTestSuite(ObjectPermissionServiceTest.class);
        suite.addTestSuite(ProfileAttributeTest.class);
        suite.addTestSuite(RepositoryMoveAndCopyTests.class);
        return suite;
    }
}
