/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: DummySecurityContextProvider.java 14920 2009-01-22 11:27:55Z lucian $
 */
public class DummySecurityContextProvider implements SecurityContextProvider {

	private String dummyUsername;
	private UserAuthorityService userAuthorityService;

	public String getDummyUsername() {
		return dummyUsername;
	}

	public void setDummyUsername(String dummyUsername) {
		this.dummyUsername = dummyUsername;
	}
	
	public String getContextUsername() {
		return getDummyUsername();
	}

	public User getContextUser() {
		String username = getContextUsername();
		if (username == null) {
			return null;
		}
		return getUserAuthorityService().getUser(null, username);
	}

	public void setAuthenticatedUser(String username) {
		// TODO Auto-generated method stub
		
	}

	public void revertAuthenticatedUser() {
		// TODO Auto-generated method stub
		
	}

	public UserAuthorityService getUserAuthorityService() {
		return userAuthorityService;
	}

	public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
		this.userAuthorityService = userAuthorityService;
	}

}
