/*
 * Copyright (C) 2005 - 2009 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.war;

import com.jaspersoft.jasperserver.war.control.OlapModelController;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/**
 *
 * @author swood
 */
public class DrillThroughConnectionKiller implements HttpSessionListener {

    public void sessionCreated(HttpSessionEvent arg0) {
        // Not needed
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();

        // destroy the drill through JDBC connections
        for ( Enumeration coll = session.getAttributeNames(); coll.hasMoreElements(); ) {
            try {
                String attName = (String) coll.nextElement();
                Object att = session.getAttribute(attName);
                OlapModelController.clearDrillThroughConnection(attName, att);
            } catch (Exception ex) {
                // don't care
            }
        }
    }

}
