package com.jaspersoft.jasperserver.war.helper;

import org.json.JSONObject;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.MessageSource;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;

/**
 */
public class JSONHelper {
    public static final String AJAX_RESPONSE_SUCCESS= "success";

    public static final String PAGINATION_FIRST_RESULT = "firstResult";
    public static final String PAGINATION_MAX_RESULT = "maxResult";
    public static final String PAGINATION_TOTAL_RESULT = "totalResult";

    public static final String ERROR_TITLE = "title";
    public static final String ERROR_MESSAGE = "message";
    public static final String ERROR_DESC = "description";
    
    protected String getPropertyIfHas(JSONObject userJson, String property) throws Exception {

        if (userJson.has(property)) {

            return userJson.getString(property);
        } else {

            return null;
        }
    }

    public JSONObject createUnexpectedExceptionJson(String title, String message, String errorDescription) throws Exception {

        JSONObject errorObject = new JSONObject();
        errorObject.put(ERROR_TITLE, title);

        errorObject.put(ERROR_MESSAGE, message);

        errorObject.put(ERROR_DESC, errorDescription);

        return errorObject;
    }

    public JSONObject createErrorJson(String error, String desc) throws Exception {

        JSONObject errorObject = new JSONObject();
        errorObject.put("message", error);

        return errorObject;
    }

    public String createDataResponseModel(JSONObject data) throws Exception {
        JSONObject responseModel = new JSONObject();

        responseModel.put("data", data);

        return responseModel.toString();
    }

    public String createErrorResponseModel(JSONObject error) throws Exception {
        JSONObject responseModel = new JSONObject();

        responseModel.put("data", new JSONObject());
        if (error != null) {

            responseModel.put("error", error);
        }

        return responseModel.toString();
    }

    public String createSuccessResponseModel() throws Exception {
        JSONObject json = new JSONObject();

        json.put("status", AJAX_RESPONSE_SUCCESS);

        return createDataResponseModel(json);
    }



}
