<%--
 Copyright (C) 2005 - 2009 JasperSoft Corporation.  All rights reserved.
 http://www.jaspersoft.com.

 Unless you have purchased a commercial license agreement from JasperSoft,
 the following license terms apply:

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2 as published by
 the Free Software Foundation.

 This program is distributed WITHOUT ANY WARRANTY; and without the
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 or write to:

 Free Software Foundation, Inc.,
 59 Temple Place - Suite 330,
 Boston, MA  USA  02111-1307
--%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/jasperserver.tld" prefix="js" %>
<%@ taglib uri="/spring" prefix="spring" %>
<%@ page errorPage="/WEB-INF/jsp/JSErrorPage.jsp" %>

<html>
<head>
    <link href="${pageContext.request.contextPath}/stylesheets/table.css" rel="stylesheet" type="text/css">
    <link href="${pageContext.request.contextPath}/stylesheets/customtooltip.css" rel="stylesheet" type="text/css">
    <link href="${pageContext.request.contextPath}/stylesheets/SearchTextBox.css" rel="stylesheet" type="text/css">
    <link href="stylesheets/std_treelook.css" type="text/css" rel="stylesheet">
    <link href="${pageContext.request.contextPath}/stylesheets/manager/editor.css" rel="stylesheet" type="text/css">
    <link href="${pageContext.request.contextPath}/stylesheets/manager.css" rel="stylesheet" type="text/css">
    <!--[if IE]>
        <link href="${pageContext.request.contextPath}/stylesheets/manager/ie-specific.css" rel="stylesheet" type="text/css" media="screen" />
    <![endif]-->
    <!--[if IE 7]>
        <link href="${pageContext.request.contextPath}/stylesheets/manager/ie7-specific.css" rel="stylesheet" type="text/css" media="screen" />
    <![endif]-->

    <script language="JavaScript"  src="scripts/edition.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/dialog.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/checkbox-utils.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/table.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/SearchTextBox.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/LinkButton.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/customTooltip.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/ListBox.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/nanotree.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/treesupport.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/validator.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/message-utils.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/utils.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/data.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/listModel.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/tenantTree.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/basemanager.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/usermanager/userViewer.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/usermanager/userEditor.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/usermanager/userCreator.js"></script>
    <script language="JavaScript" src="${pageContext.request.contextPath}/scripts/usersandroles/usermanager/userManager.js"></script>
</head>

<body>

<table class="manager" cellspacing="0px" cellpadding="0px">
    <tr>
        <td class="fsection managerTitle">
            <spring:message code="jsp.userManager.header"/>
        </td>
    </tr>
    <tr>
        <td class="managerHeader">
            <div>
                <div class="fl searchBorder">
                    <div id="searchNameInput" class="searchInputContainer mainSearch"></div>
                </div>
                <input id="searchBtn" class="dialogButton fl searchBtn" type="button" value="<spring:message code="jsp.userManager.search"/>" />
                <h2 class="fr mainToolbar">
                    <a id="addItemBtn" href="#null"><spring:message code="jsp.userManager.addUser"/></a>
                </h2>
                <span class="cb"></span>
            </div>
        </td>
    </tr>
    <tr>
        <td id="managerBody" class="managerBody">
            <table id="managerTable" class="panelGroup" cellspacing="0px" cellpadding="0px">
                <tr>
                    <td id="treePanelHeader" class="panelHeader">
                        <!-- Tree title-->
                        <h2><spring:message code="jsp.userManager.organizations"/></h2>
                    </td>
                    <td class="panelHeader mainListFrame">
                        <!-- List title-->
                        <h2><spring:message code="jsp.userManager.users"/></h2>
                    </td>
                    <td class="panelHeader">
                        <h2><spring:message code="jsp.userManager.details"/></h2>
                    </td>
                </tr>

                <tr>
                    <td id="treePanelContent" class="panelFrame treeFrame">
                        <!-- Tree-->
                        <div id="tenantTree" class="panelContent panelBorder tenantTree" style="overflow:auto;">

                        </div>
                    </td>
                    <td class="panelFrame mainListFrame">
                        <!-- List-->
                        <div id="items" style="height:350px;" class="panelContent panelBorder mainList">
                        </div>
                    </td>
                    <td class="panelFrameLast">
                        <div id="nothingSelected" class="panelBorder"></div>
                        <jsp:include page="userViewer.jsp"/>
                        <jsp:include page="userEditor.jsp"/>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>

<form action="j_acegi_switch_user" method="post" id="loginAsForm" name="loginAsForm">
    <input id="j_username"  name="j_username" type="hidden" />
</form>

<!-- Message dialog-->
<jsp:include page="userCreator.jsp"/>
<jsp:include page="common.jsp"/>

<div id="ajaxbuffer" style="display: none;"></div>

<script type="text/javascript">
    BaseUserAndRoleManager.State.flowExecutionKey = '${flowExecutionKey}';
    BaseUserAndRoleManager.Configuration = ${configuration};
    BaseUserAndRoleManager.defaultUser = '${defaultUser}';
    BaseUserAndRoleManager.currentUser  = '${currentUser}';
    BaseUserAndRoleManager.currentUserRoles = ${currentUserRoles};

    SearchTextBox.CLEAR_IMAGE_SRC = 'images/clearValue.gif';
    SearchTextBox.CLEAR_IMAGE_DISABLED_SRC = 'images/pixel.gif';

    PaginatedListBox.PAGE_LINK_PREV_TITLE = '<spring:message code="jsp.userManager.prev" javaScriptEscape="true"/>';
    PaginatedListBox.PAGE_LINK_NEXT_TITLE = '<spring:message code="jsp.userManager.next" javaScriptEscape="true"/>';
    PaginatedListBox.SHOWING_TITLE = '<spring:message code="jsp.userManager.showing" javaScriptEscape="true"/>';
    PaginatedListBox.ABOUT_TITLE = '<spring:message code="jsp.userManager.about" javaScriptEscape="true"/>';

    var userManagerMessages = {};
    userManagerMessages['defaultSearchText']  = '<spring:message code="jsp.userManager.defaultUserSearchText" javaScriptEscape="true"/>';
    <%--userManagerMessages['defaultUserSearchText']  = '<spring:message code="jsp.userManager.defaultUserSearchText" javaScriptEscape="true"/>';--%>
    userManagerMessages['assignerDefaultSearchText']  = '<spring:message code="jsp.roleManager.defaultRoleSearchText" javaScriptEscape="true"/>';
    userManagerMessages['enabledUser'] = '<spring:message code="jsp.userManager.enabledUser" javaScriptEscape="true"/>';
    userManagerMessages['disabledUser'] = '<spring:message code="jsp.userManager.disabledUser" javaScriptEscape="true"/>';
    userManagerMessages['externalUser'] = '<spring:message code="jsp.userManager.externalUser" javaScriptEscape="true"/>';

    userManagerMessages['deleteUserHeader'] = '<spring:message code="jsp.userManager.deleteUserHeader" javaScriptEscape="true"/>';
    userManagerMessages['deleteUserMessage'] = '<spring:message code="jsp.userManager.deleteUserMessage" javaScriptEscape="true"/>';
    userManagerMessages['deleteUserCancel'] = '<spring:message code="jsp.userManager.deleteUserCancel" javaScriptEscape="true"/>';
    userManagerMessages['deleteUserOk'] = '<spring:message code="jsp.userManager.deleteUserOk" javaScriptEscape="true"/>';

    userManagerMessages['cancelItemEditHeader'] = '<spring:message code="jsp.userManager.cancelUserEditHeader" javaScriptEscape="true"/>';
    userManagerMessages['cancelItemEditMessage'] = '<spring:message code="jsp.userManager.cancelUserEditMessage" javaScriptEscape="true"/>';
    userManagerMessages['cancelItemEditOk'] = '<spring:message code="jsp.userManager.cancelUserEditOk" javaScriptEscape="true"/>';
    userManagerMessages['cancelItemEditCancel'] = '<spring:message code="jsp.userManager.cancelUserEditCancel" javaScriptEscape="true"/>';

    userManagerMessages['noUsersFound'] = '<spring:message code="jsp.userManager.noUsersFound" javaScriptEscape="true"/>';
    userManagerMessages['noRolesFound'] = '<spring:message code="jsp.userManager.noRolesFound" javaScriptEscape="true"/>';
    userManagerMessages['unexpectedException'] = '<spring:message code="jsp.userManager.unexpectedException" javaScriptEscape="true"/>';

    userManagerMessages['userNameIsAlreadyInUse'] = '<spring:message code="jsp.userManager.userCreator.validation.userNameIsAlreadyInUse" javaScriptEscape="true"/>';
    userManagerMessages['invalidEmail'] = '<spring:message code="jsp.userManager.userCreator.validation.invalidEmail" javaScriptEscape="true"/>';
    userManagerMessages['invalidConfirmPassword'] = '<spring:message code="jsp.userManager.userCreator.validation.invalidConfirmPassword" javaScriptEscape="true"/>';

    UserListModel.FULL_NAME = '<spring:message code="jsp.userManager.userEditor.fullName" javaScriptEscape="true"/>';
    UserListModel.TENANT_NAME = '<spring:message code="jsp.userManager.organization" javaScriptEscape="true"/>';

    var userManager;
    document.observe("dom:loaded", function() {

        if (!JS.isProVersion()) {

            $('treePanelHeader').remove();
            $('treePanelContent').remove();
        }

        userManager = new UserManager(new MessageSource(userManagerMessages), BaseUserAndRoleManager.defaultUser);
    });

    Event.observe(window, 'resize', function() {

        function doResize() {
            if (userManager) {

                userManager.resize();
            }
        }

        setTimeout(doResize, 500);
    });

</script>
</body>

</html>
