var UserManager = Class.create(BaseUserAndRoleManager, {
    initialize: function($super, messageSource, defaultUser) {

        var dataRetriever = this.createDataRetriever();
        var dataUpdater = this.createDataUpdater();

        var viewer = new UserViewer(messageSource);
        var editor = this.createEditor(messageSource, dataRetriever, dataUpdater);
        var creator = this.createCreator(messageSource, dataRetriever);

        var defaultSearchName = UserUtil.getUserNameWithoutTenant(defaultUser);
        var defaultTenantId = UserUtil.getTenantWithoutUserName(defaultUser);

        $super(viewer, editor, creator, dataRetriever, dataUpdater, messageSource,
                defaultSearchName, defaultTenantId, defaultUser);

        var regExpRepresenter = new RegExpRepresenter(BaseUserAndRoleManager.Configuration.userNameNotSupportedSymbols);
        $('userNameNotSupportedSymbols').innerHTML += regExpRepresenter.getRepresentedString();
    },

    createDataRetriever : function () {

        var dataRetriever =
                new UserDataRetriever(BaseUserAndRoleManager.State.flowExecutionKey, this.getBaseErrorHandler());

        dataRetriever.onItemsRetrieved = function (data) {

            var model = new UserListModel(data.users, data.firstResult, data.maxResult, data.totalResult,
                    this.tenantTree.getTenantPathMap());

            model.getNoItemsMessage = function () {

                return this.messageSource.getMessage('noUsersFound');

            }.bind(this);

            this.itemList.setModel(model);

            this.selectPreviousItem();
            new HoverBehavior('#items td.list_default', '#items td.listItemDisabled');
        }.bind(this);
                
        return dataRetriever;
    },

    createDataUpdater : function () {

        var dataUpdater =
                new UserDataUpdater(BaseUserAndRoleManager.State.flowExecutionKey, this.getBaseErrorHandler());


        return dataUpdater;
    },

    createEditor : function (messageSource, dataRetriever, dataUpdater) {

        var editor = new UserEditor(messageSource, dataRetriever, dataUpdater);

        editor.onsave = function (originalItem, newItem) {

            var un = UserUtil.getUserNameWithTenant(newItem.userName, newItem.tenantId);
            
            this.selectedItem = un;
            this.dataUpdater.updateItem(originalItem, newItem);
        }.bind(this);

        return editor;
    },

    createCreator : function (messageSource, dataRetriever) {

        var creator = new UserCreator(messageSource, dataRetriever);;

        creator.onsubmit = function (user) {

            var un = UserUtil.getUserNameWithTenant(user.userName, user.tenantId);

            this.selectedItem = un;
            this.dataUpdater.createItem(user);
        }.bind(this);

        return creator;
    }

});


//var UserManager = Class.create(Manager, {
//    initialize: function($super, messageSource) {
//
//        var dataRetriever = this.createDataRetriever();
//
//        $super(new UserViewer(messageSource), new UserEditor(messageSource), new UserCreator(messageSource), dataRetriever, messageSource);
//    },
//
//    createDataRetriever : function () {
//
//        var dataRetriever = new UserDataRetriever(Manager.State.flowExecutionKey);
//
//        dataRetriever.onItemsRetrieved = function (data) {
//
//            var model = new UserListModel(data.users, data.firstResult, data.maxResult, data.totalResult,
//                    this.tenantTree.getTenantPathMap());
//
//            this.itemList.setModel(model);
//        }.bind(this);
//
//        return dataRetriever;
//    }
//});