var UserViewer = Class.create(ItemViewer, {
    initialize : function ($super, messageSource) {

        $super('userViewer', messageSource);

        this.loginAsUserBtn = new InputButton('loginAsUserBtn', this.toolbarBtnCss[0], this.toolbarBtnCss[1], 
                this.toolbarBtnCss[2], this.toolbarBtnCss[3]);

        this.userName = $('userName');
        this.fullName = $('fullName');
        this.email = $('email');
        this.roles = $('roles');
        this.attributes = $('attributes');
        this.enabled = $('userEnabled');
        this.external = $('userExternal');

        this.primaryUserDetails = $('primaryUserDetails');

        var viewerInstance = this;

        this.loginAsUserBtn.onclick = function () {

            this.onlogin(this.item);
        }.bind(this);
    },

    getConfirmDelete : function () {
        var user = this.item;

        var name = UserUtil.getUserNameWithoutTenant(user.userName);
        var confirmDelete = new ConfirmMsgBox(
                "userEditorDeleteConfirmation",
                this.messageSource.getMessage('deleteUserHeader'),
                this.messageSource.getMessage('deleteUserMessage', ['<b>' + name + '</b>']),
                this.messageSource.getMessage('deleteUserOk'),
                this.messageSource.getMessage('deleteUserCancel'));

        return confirmDelete;
    },

    refresh : function() {
        var user = this.item;

        if (user) {
            var userName = UserUtil.getUserNameWithoutTenant(user.userName);

            this.userName.innerHTML = userName;
            this.fullName.innerHTML = user.fullName;
            this.email.innerHTML = user.email;

            if (user.enabled) {

                this.enabled.innerHTML = this.messageSource.getMessage('enabledUser');
                this.primaryUserDetails.removeClassName('userDetailsTitleDisabled');

                this.loginAsUserBtn.setDisabled(false);
            } else {

                this.enabled.innerHTML = this.messageSource.getMessage('disabledUser');
                this.primaryUserDetails.addClassName('userDetailsTitleDisabled');

                this.loginAsUserBtn.setDisabled(true);
            }

            this.external.style.visibility = (user.external) ? '' : 'hidden';

            this._createRoleLinks();
            this._createAttributes();

            var qName = UserUtil.getUserNameWithTenant(user.userName, user.tenantId);
            this.deleteItemBtn.setDisabled(qName == BaseUserAndRoleManager.currentUser)
        } else {
            this.userName.innerHTML = '';
            this.fullName.innerHTML = '';
            this.email.innerHTML = '';

            this.roles.innerHTML = '';
            this.roles.innerHTML = '&nbsp;';

            this.external.style.visibility = 'hidden';

        }
    },

    _createRoleLinks : function() {

        var viewerInstance = this;
        var user = this.item;

        this.roles.innerHTML = '';

        var roles = user.roles;
        if (roles) {

            var i = 0;
            roles.each(function (role) {

                var link = viewerInstance._createLink(viewerInstance.roles, role.roleName);

                link.onclick = function () {

                    var rn = RoleUtil.getRoleNameWithTenant(role.roleName, role.tenantId);
                    document.location="flow.html?_flowId=roleListFlow&curlnk=3&roleName="
                            + encodeUriParameter(rn);
                }

                if (i < roles.length - 1) {
                    viewerInstance.roles.appendChild(document.createTextNode(", "));
                }

                i ++;
            });
        }
    },

    _createAttributes : function() {
        var attributesHtml = UserUtil.attributesToString(this.item.attributes);

        this.attributes.innerHTML = (attributesHtml.blank()) ? '&nbsp;' : attributesHtml;
    },

    isItemViewed : function(user) {
        return (this.item && this.item.userName == user.userName);
    },

    onlogin : function(user) {

        var name = UserUtil.getUserNameWithTenant(user.userName, user.tenantId);
//        document.location="j_acegi_switch_user?j_username=" + encodeUriParameter(name);

        $('j_username').value = name;
        $('loginAsForm').submit();
    }
});
